/*
 * Decompiled with CFR 0.152.
 */
package com.trg.search.hibernate;

import com.trg.search.Metadata;
import com.trg.search.MetadataUtil;
import com.trg.search.hibernate.HibernateEntityMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateMetadataUtil
implements MetadataUtil {
    private static Map<SessionFactory, HibernateMetadataUtil> map = new HashMap<SessionFactory, HibernateMetadataUtil>();
    private SessionFactory sessionFactory;

    public static HibernateMetadataUtil getInstanceForSessionFactory(SessionFactory sessionFactory) {
        HibernateMetadataUtil instance = map.get(sessionFactory);
        if (instance == null) {
            instance = new HibernateMetadataUtil();
            instance.sessionFactory = sessionFactory;
            map.put(sessionFactory, instance);
        }
        return instance;
    }

    protected HibernateMetadataUtil() {
    }

    public Serializable getId(Object entity) {
        if (entity == null) {
            throw new NullPointerException("Cannot get ID from null object.");
        }
        return this.get(entity.getClass()).getIdValue(entity);
    }

    public boolean isId(Class<?> rootClass, String propertyPath) {
        if (propertyPath == null || "".equals(propertyPath)) {
            return false;
        }
        if (propertyPath.equals("id") || propertyPath.endsWith(".id") && this.get(rootClass, propertyPath.substring(0, propertyPath.length() - 3)).isEntity()) {
            return true;
        }
        int pos = propertyPath.lastIndexOf(".");
        if (pos != -1) {
            Metadata parentType = this.get(rootClass, propertyPath.substring(0, pos));
            if (!parentType.isEntity()) {
                return false;
            }
            return propertyPath.substring(pos + 1).equals(parentType.getIdProperty());
        }
        return propertyPath.equals(this.sessionFactory.getClassMetadata(rootClass).getIdentifierPropertyName());
    }

    public Metadata get(Class<?> entityClass) {
        ClassMetadata cm = this.sessionFactory.getClassMetadata(entityClass);
        if (cm == null) {
            Map m = this.sessionFactory.getAllClassMetadata();
            ArrayList<ClassMetadata> candidates = new ArrayList<ClassMetadata>();
            for (ClassMetadata md : m.values()) {
                if (!md.getMappedClass(EntityMode.POJO).isAssignableFrom(entityClass)) continue;
                candidates.add(md);
            }
            if (candidates.size() == 1) {
                return new HibernateEntityMetadata(this.sessionFactory, (ClassMetadata)candidates.get(0), null);
            }
            if (candidates.size() > 1) {
                block1: for (int i = candidates.size() - 1; i >= 0; --i) {
                    for (int j = 0; j < candidates.size(); ++j) {
                        if (i == j || !((ClassMetadata)candidates.get(i)).getMappedClass(EntityMode.POJO).isAssignableFrom(((ClassMetadata)candidates.get(j)).getMappedClass(EntityMode.POJO))) continue;
                        candidates.remove(i);
                        continue block1;
                    }
                }
                return new HibernateEntityMetadata(this.sessionFactory, (ClassMetadata)candidates.get(0), null);
            }
            throw new IllegalArgumentException("Unable to introspect " + entityClass.toString() + ". The class is not a registered Hibernate entity.");
        }
        return new HibernateEntityMetadata(this.sessionFactory, cm, null);
    }

    public Metadata get(Class<?> rootEntityClass, String propertyPath) {
        try {
            Metadata md = this.get(rootEntityClass);
            if (propertyPath == null || "".equals(propertyPath)) {
                return md;
            }
            String[] chain = propertyPath.split("\\.");
            for (int i = 0; i < chain.length; ++i) {
                md = md.getPropertyType(chain[i]);
            }
            return md;
        }
        catch (HibernateException ex) {
            throw new PropertyNotFoundException("Could not find property '" + propertyPath + "' on class " + rootEntityClass + ".");
        }
    }
}

