/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository.jdbc;

import java.io.File;
import java.io.IOException;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.ow2.petals.registry.api.config.DBConfiguration;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.core.repository.RepositoryLifecycle;
import org.ow2.petals.registry.core.repository.hibernate.HibernateHelper;
import org.ow2.petals.registry.core.repository.jdbc.JDBCRepository;

public class JDBCRepositoryLifeCycle
extends RepositoryLifecycle {
    private static final String FILE = ":file:";
    private static final String HSQL_DRIVER = "org.hsqldb.jdbcDriver";

    public JDBCRepositoryLifeCycle(JDBCRepository repository) {
        super(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInit(Context context) throws LifeCycleException {
        super.doInit(context);
        DBConfiguration config = context.getConfiguration().getDbConfiguration();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Configuring Hibernate session with " + config.toString()));
        }
        if ("jdbc:hsqldb:file:registry-database01".equals(config.getUrl())) {
            String initialURL = config.getUrl();
            int end = initialURL.indexOf(FILE) + FILE.length();
            String prefix = initialURL.substring(0, end);
            String suffix = initialURL.substring(end, initialURL.length());
            if (!suffix.equals(context.getWorkspace().getRepositoryRootPath().getAbsolutePath())) {
                File path = new File(context.getWorkspace().getRepositoryRootPath(), suffix);
                if (!path.exists()) {
                    try {
                        path.createNewFile();
                    }
                    catch (IOException e) {
                        throw new LifeCycleException("Can not create the database storage path under " + path.getAbsolutePath(), (Throwable)e);
                    }
                }
                String url = prefix + path.getAbsolutePath() + ";shutdown=true";
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Updated HSQL URL is now '" + url + "'"));
                }
                config.setUrl(url);
            }
        }
        HibernateHelper hibernateHelper = new HibernateHelper();
        hibernateHelper.configureSession(config);
        ((JDBCRepository)this.repository).setHibernateHelper(hibernateHelper);
        if (config.getDriver().startsWith(HSQL_DRIVER)) {
            Session session = null;
            try {
                session = hibernateHelper.getSession();
                SQLQuery query = session.createSQLQuery("SET WRITE_DELAY FALSE");
                query.executeUpdate();
            }
            catch (Exception e) {
                this.log.warn((Object)"Can not set the write delay to 0, will pause problems on restart since data may not be deleted from database on stop...");
            }
            finally {
                if (session != null) {
                    try {
                        session.disconnect();
                    }
                    catch (HibernateException e) {}
                }
            }
        }
    }

    protected void doStop() throws LifeCycleException {
        HibernateHelper hibernateHelper = ((JDBCRepository)this.repository).getHibernateHelper();
        if (!hibernateHelper.getSessionFactory().isClosed()) {
            try {
                hibernateHelper.getSessionFactory().close();
            }
            catch (Exception e) {
                this.log.warn((Object)("Closing the session factory causes the following exception : " + e.getMessage()));
            }
        }
    }
}

