/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.transport.cxf;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.petals.registry.api.ws.service.RegistryService;

public class ClientManager {
    private Map<String, RegistryService> clients = new HashMap<String, RegistryService>();

    public RegistryService getRegistryClient(String address) {
        return this.getRegistryClient(address, 10000L);
    }

    public RegistryService getRegistryClient(String address, long timeout) {
        RegistryService client = this.clients.get(address);
        if (client == null) {
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
            factory.setAddress(address);
            factory.setServiceClass(RegistryService.class);
            client = (RegistryService)factory.create();
            Client cxfClient = ClientProxy.getClient((Object)client);
            if (cxfClient != null) {
                HTTPConduit conduit = (HTTPConduit)cxfClient.getConduit();
                HTTPClientPolicy policy = new HTTPClientPolicy();
                policy.setConnectionTimeout(timeout);
                policy.setReceiveTimeout(timeout);
                conduit.setClient(policy);
            }
            this.clients.put(address, client);
        }
        return client;
    }
}

