/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.annotations.jwsValImpl;

import spoon.aval.Validator;
import spoon.aval.annotations.jwsVal.ValidEndPointInterface;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.ModifierKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidEndPointInterfaceValidator
implements Validator<ValidEndPointInterface> {
    @Override
    public void check(ValidationPoint<ValidEndPointInterface> vp) {
        if (vp.getProgramElement() instanceof CtInterface) {
            CtInterface endPointItf = (CtInterface)vp.getProgramElement();
            boolean isPublic = endPointItf.hasModifier(ModifierKind.PUBLIC);
            boolean definesEndPoint = vp.getDslAnnotation().getElementValue("endPointInterface").equals("");
            boolean definesServiceName = vp.getDslAnnotation().getElementValue("serviceName").equals("");
            if (!isPublic) {
                ValidationPoint.report(Severity.ERROR, (CtElement)endPointItf, "An EndPointInterface must be public", new ProblemFixer[0]);
            }
            if (definesEndPoint) {
                ValidationPoint.report(Severity.ERROR, (CtElement)vp.getDslAnnotation(), "An EndPointInterface cannot define the attribute 'endPointInterface'", new ProblemFixer[0]);
            }
            if (definesServiceName) {
                ValidationPoint.report(Severity.ERROR, (CtElement)vp.getDslAnnotation(), "An EndPointInterface cannot define the attribute 'serviceName'", new ProblemFixer[0]);
            }
        }
    }
}

