/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.annotations.jwsValImpl;

import java.util.List;
import javax.jws.WebParam;
import spoon.aval.Validator;
import spoon.aval.annotations.jwsVal.ValidOneway;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidOnewayValidator
implements Validator<ValidOneway> {
    @Override
    public void check(ValidationPoint<ValidOneway> vp) {
        if (vp.getProgramElement() instanceof CtMethod) {
            CtMethod oneway = (CtMethod)vp.getProgramElement();
            boolean isVoid = oneway.getType().equals(oneway.getFactory().Type().createReference(Void.TYPE));
            boolean declaresExceptions = !oneway.getThrownTypes().isEmpty();
            CtParameter<?> OUTorINOUTParams = this.hasINorINOUTParams(oneway);
            if (!isVoid) {
                ValidationPoint.report(Severity.ERROR, (CtElement)oneway, "Oneway operations must have no return value", new ProblemFixer[0]);
            }
            if (declaresExceptions) {
                ValidationPoint.report(Severity.ERROR, (CtElement)oneway, "Oneway operations must not throw checked Exceptions", new ProblemFixer[0]);
            }
            if (OUTorINOUTParams != null) {
                ValidationPoint.report(Severity.ERROR, OUTorINOUTParams, "Parameters in Oneway operations must not be OUT or INOUT", new ProblemFixer[0]);
            }
        }
    }

    private CtParameter<?> hasINorINOUTParams(CtMethod<?> oneway) {
        List params = oneway.getParameters();
        for (CtParameter parameter : params) {
            WebParam ann = (WebParam)parameter.getAnnotation(WebParam.class);
            if (ann != null) continue;
        }
        return null;
    }
}

