/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.support.validator;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.aval.Validator;
import spoon.aval.annotation.value.RefersTo;
import spoon.aval.processing.ValidationPoint;
import spoon.processing.ProblemFixer;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.Query;
import spoon.support.query.AnnotationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefersToValidator
implements Validator<RefersTo> {
    private static Map<Class<? extends Annotation>, List<CtElement>> cache = new HashMap<Class<? extends Annotation>, List<CtElement>>();

    @Override
    public void check(ValidationPoint<RefersTo> vp) {
        Class<? extends Annotation> referedType = vp.getValAnnotation().value();
        String referedAttributeName = vp.getValAnnotation().attribute();
        String dslAttributeName = ((CtFieldReference)vp.getDslElement()).getSimpleName();
        Object dslAttribute = vp.getDslAnnotation().getElementValue(dslAttributeName);
        Factory f = vp.getProgramElement().getFactory();
        List posibles = cache.get(referedType);
        if (posibles == null) {
            posibles = Query.getElements((Factory)f, (Filter)new AnnotationFilter(referedType));
            cache.put(referedType, posibles);
        }
        CtAnnotation dslAnnotation = vp.getDslAnnotation();
        for (CtElement posible : posibles) {
            CtAnnotation refered = posible.getAnnotation(f.Type().createReference(referedType));
            Object referedVal = refered.getElementValue(referedAttributeName);
            if (referedVal == null) {
                CtElement dslElement = vp.getDslElement().getDeclaration();
                String message = String.valueOf(referedAttributeName) + " is not an attribute of the annotation " + referedType;
                if (dslElement != null) {
                    ValidationPoint.report(Severity.ERROR, dslElement, message, new ProblemFixer[0]);
                }
                return;
            }
            if (!referedVal.equals(dslAttribute)) continue;
            return;
        }
        String message = vp.getValAnnotation().message().replace("?val", dslAttribute.toString());
        ValidationPoint.report(vp.getValAnnotation().severity(), (CtElement)dslAnnotation, message, vp.fixerFactory(vp.getValAnnotation().fixers()));
    }
}

