/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import org.ow2.petals.launcher.PetalsLauncherException;
import org.ow2.petals.launcher.configuration.Configuration;

public class PetalsClassLoader
extends URLClassLoader {
    public PetalsClassLoader(Configuration config) throws PetalsLauncherException {
        super(new URL[0], PetalsClassLoader.class.getClassLoader());
        try {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("petals-kernel") && name.endsWith(".jar");
                }
            };
            for (File jar : config.getLibDirectory().listFiles(filter)) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new PetalsLauncherException(e);
        }
    }
}

