/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.petals.launcher.PetalsClassLoader;
import org.ow2.petals.launcher.PetalsLauncherException;
import org.ow2.petals.launcher.configuration.Configuration;
import org.ow2.petals.launcher.configuration.DefaultConfiguration;

public class PetalsLauncher {
    public static final String NAME = "Petals ESB Server";
    public static final String PETALS_HOME_PROPERTY_NAME = "petals.home";
    public static final String[] TITLE = new String[]{"     ___   ____ __   ___    __    ____   ____ ____ ___  ", "    / _ \\ / __// /_ / _ |  / /   / __/  / __// __// _ ) ", "   / ___// _/ / __// __ | / /__ _\\ \\   / _/ _\\ \\ / _  | ", "  /_/   /___/ \\__//_/ |_|/____//___/  /___//___//____/  ", ""};

    protected void parseOptions(String[] options) {
        if (options[0].equals("-V") || options[0].equals("--version")) {
            this.printLauncherVersion();
        } else if (options[0].equals("-h") || options[0].equals("--help")) {
            this.printUsageMessage();
        } else {
            System.out.println("Invalid option: " + options[0]);
            System.out.println("Try 'petals-esb.sh --help' for more information.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchPetalsServer(Configuration config) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException, PetalsLauncherException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        PetalsClassLoader petalsKernelClassLoader = new PetalsClassLoader(config);
        Class<?> petalsServerClass = petalsKernelClassLoader.loadClass("org.ow2.petals.kernel.server.PetalsServerImpl");
        Object serverInstance = petalsServerClass.newInstance();
        Thread.currentThread().setContextClassLoader(petalsKernelClassLoader);
        Method initMethod = petalsServerClass.getMethod("init", new Class[0]);
        Method startMethod = petalsServerClass.getMethod("start", new Class[0]);
        System.out.println("Initializing server ...");
        initMethod.invoke(serverInstance, new Object[0]);
        System.out.println("Starting server ...");
        startMethod.invoke(serverInstance, new Object[0]);
        Object obj = serverInstance;
        synchronized (obj) {
            serverInstance.wait();
        }
    }

    protected void printLauncherVersion() {
        StringBuilder sb = new StringBuilder(NAME).append(' ');
        sb.append(PetalsLauncher.class.getPackage().getImplementationVersion());
        sb.append('\n');
        sb.append(System.getProperty("java.runtime.name")).append(' ');
        sb.append(System.getProperty("java.runtime.version")).append('\n');
        sb.append(System.getProperty("os.name")).append(' ');
        sb.append(System.getProperty("os.version"));
        System.out.println(sb.toString());
    }

    protected void printUsageMessage() {
        String jar = PetalsLauncher.class.getProtectionDomain().getCodeSource().getLocation().getFile();
        System.out.println("Start Petals ESB Server");
        System.out.println();
        System.out.println("usage: java -jar .../" + new File(jar).getName() + " [--help] [--version]");
        System.out.println("\t-h,--help      Print this help message and exit");
        System.out.println("\t-V,--version   Print the version number and exit");
        System.out.println();
    }

    public static void main(String[] args) {
        try {
            PetalsLauncher petalsLauncher = new PetalsLauncher();
            String path = System.getProperty(PETALS_HOME_PROPERTY_NAME);
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException("Variable [petals.home] is not set.");
            }
            DefaultConfiguration config = new DefaultConfiguration(path);
            if (args.length == 0) {
                for (String line : TITLE) {
                    System.out.println(line);
                }
                petalsLauncher.launchPetalsServer(config);
            } else {
                petalsLauncher.parseOptions(args);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

