/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.configuration;

import java.io.File;
import org.ow2.petals.launcher.configuration.Configuration;
import org.ow2.petals.launcher.configuration.ConfigurationException;

public class DefaultConfiguration
implements Configuration {
    public static final String DEFAULT_CONF_DIR = "conf";
    public static final String DEFAULT_INSTALL_DIR = "install";
    public static final String DEFAULT_INSTALLED_DIR = "installed";
    public static final String DEFAULT_LIB_DIR = "lib";
    public static final String DEFAULT_WORK_DIR = "work";
    public static final String DEFAULT_TOPOLOGY_FILE = "topology.xml";
    private File home;

    public DefaultConfiguration(String home) {
        this.home = new File(home);
    }

    @Override
    public File getConfDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_CONF_DIR);
    }

    @Override
    public File getHomeDirectory() {
        return this.home;
    }

    @Override
    public File getInstallDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_INSTALL_DIR);
    }

    @Override
    public File getInstalledDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_INSTALLED_DIR);
    }

    @Override
    public File getLibDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_LIB_DIR);
    }

    @Override
    public File getWorkDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_WORK_DIR);
    }

    @Override
    public int getStartupTimeoutSeconds() {
        return 20;
    }

    @Override
    public boolean isValid() throws ConfigurationException {
        for (File d : new File[]{this.getConfDirectory(), this.getHomeDirectory(), this.getInstallDirectory(), this.getInstalledDirectory()}) {
            if (d.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

