/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.AegisXMLStreamDataReader;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.databinding.DataBindingValidation2;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.StaxValidationManager;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataReader
implements DataReader<XMLStreamReader>,
DataBindingValidation2 {
    private AegisDatabinding databinding;
    private AegisXMLStreamDataReader reader;
    private Bus bus;
    private ServiceInfo serviceInfo;
    private boolean validate;

    public XMLStreamDataReader(AegisDatabinding databinding, Bus bus) {
        this.bus = bus;
        this.databinding = databinding;
        this.reader = new AegisXMLStreamDataReader(databinding.getAegisContext());
    }

    @Override
    public Object read(MessagePartInfo part, XMLStreamReader input) {
        Type type = this.databinding.getType(part);
        try {
            StaxValidationManager mgr;
            if (this.validate && (mgr = this.bus.getExtension(StaxValidationManager.class)) != null) {
                mgr.setupValidation(input, this.serviceInfo);
            }
            return this.reader.read(input, type);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public Object read(QName name, XMLStreamReader input, Class typeClass) {
        return this.read(input);
    }

    @Override
    public Object read(XMLStreamReader input) {
        try {
            return this.reader.read(input, (Type)null);
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.reader.getContext().setAttachments(attachments);
    }

    @Override
    public void setProperty(String prop, Object value) {
        this.reader.setProperty(prop, value);
    }

    @Override
    public void setSchema(Schema s) {
        this.reader.setSchema(s);
    }

    @Override
    public void setValidationServiceModel(ServiceInfo serviceModel) {
        this.serviceInfo = serviceModel;
        this.validate = true;
    }
}

