/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.messaging.exchange.ContextualMessageExchangeImplBuilder;
import org.ow2.petals.jbi.messaging.exchange.LoggingUtil;
import org.ow2.petals.jbi.messaging.exchange.MEPPatternConstants;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;

public abstract class AbstractContextualMessageExchangeFactory
implements MessageExchangeFactory {
    private LoggingUtil log;
    private ContextualMessageExchangeImplBuilder messageExchangeImplBuilder;

    protected AbstractContextualMessageExchangeFactory(ServiceEndpoint consumerEndpoint, ContextualMessageExchangeImplBuilder messageExchangeImplBuilder, Logger logger) {
        assert (consumerEndpoint != null);
        this.messageExchangeImplBuilder = messageExchangeImplBuilder;
        this.log = new LoggingUtil(logger);
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        this.log.call();
        return (InOnly)this.buildExchangeDecorator(MEPPatternConstants.IN_ONLY.value());
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        this.log.call();
        return (InOptionalOut)this.buildExchangeDecorator(MEPPatternConstants.IN_OPTIONAL_OUT.value());
    }

    public InOut createInOutExchange() throws MessagingException {
        this.log.call();
        return (InOut)this.buildExchangeDecorator(MEPPatternConstants.IN_OUT.value());
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        this.log.call();
        return (RobustInOnly)this.buildExchangeDecorator(MEPPatternConstants.ROBUST_IN_ONLY.value());
    }

    public MessageExchange createExchange(QName serviceName, QName operationName) throws MessagingException {
        this.log.call("Service Name : " + serviceName + " - operationName : " + operationName);
        assert (serviceName != null);
        assert (operationName != null);
        MessageExchangeWrapper messageExchangeDecorator = this.buildExchangeDecorator(null);
        messageExchangeDecorator.setService(serviceName);
        messageExchangeDecorator.setOperation(operationName);
        return messageExchangeDecorator;
    }

    public MessageExchange createExchange(URI pattern) throws MessagingException {
        this.log.call(pattern);
        assert (pattern != null);
        this.checkPatternIsJBISupportedPattern(pattern);
        return this.buildExchangeDecorator(pattern);
    }

    private void checkPatternIsJBISupportedPattern(URI pattern) throws MessagingException {
        if (!(MessageExchangeImpl.IN_ONLY_PATTERN.equals(pattern) || MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN.equals(pattern) || MessageExchangeImpl.IN_OUT_PATTERN.equals(pattern) || MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN.equals(pattern) || MEPPatternConstants.IN_ONLY.equals(pattern) || MEPPatternConstants.ROBUST_IN_ONLY.equals(pattern) || MEPPatternConstants.IN_OUT.equals(pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(pattern))) {
            throw new MessagingException("This Message Exchange Pattern is not recognized by JBI.");
        }
    }

    private MessageExchangeWrapper buildExchangeDecorator(URI pattern) throws MessagingException {
        this.log.call(pattern);
        MessageExchangeImpl messageExchangeImpl = this.messageExchangeImplBuilder.build();
        this.setFactorySpecificTarget(messageExchangeImpl);
        return this.createMessageExchangeDecoratorForPattern(messageExchangeImpl, pattern);
    }

    protected void setFactorySpecificTarget(MessageExchangeImpl exchange) {
    }

    protected abstract MessageExchangeWrapper createMessageExchangeDecoratorForPattern(MessageExchangeImpl var1, URI var2);

    protected boolean isInOptionalOutPattern(URI pattern) {
        return MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN.equals(pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(pattern);
    }

    protected boolean isInOutPattern(URI pattern) {
        return MessageExchangeImpl.IN_OUT_PATTERN.equals(pattern) || MEPPatternConstants.IN_OUT.equals(pattern);
    }

    protected boolean isRobustInOnlyPattern(URI pattern) {
        return MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN.equals(pattern) || MEPPatternConstants.ROBUST_IN_ONLY.equals(pattern);
    }

    protected boolean isInOnlyPattern(URI pattern) {
        return MessageExchangeImpl.IN_ONLY_PATTERN.equals(pattern) || MEPPatternConstants.IN_ONLY.equals(pattern);
    }
}

