/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingUtil {
    protected Logger log;
    protected String name;

    public LoggingUtil(Logger logger) {
        this(logger, "");
    }

    public LoggingUtil(Logger logger, String loggerName) {
        this.log = logger;
        loggerName = loggerName != null && loggerName.trim().length() > 0 ? "[" + loggerName + "] " : "";
        this.name = loggerName;
    }

    public void call() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod());
        }
    }

    public void call(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-CALL-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void start() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod());
        }
    }

    public void start(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-START-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void end() {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod());
        }
    }

    public void end(Object msg) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + "-END-" + LoggingUtil.classAndMethod() + " " + msg);
        }
    }

    public void debug(Object message) {
        if (this.log != null && this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, this.name + LoggingUtil.classAndMethod() + " " + message);
        }
    }

    public void info(Object message) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.INFO, this.name + LoggingUtil.classAndMethod() + " " + message);
            } else {
                this.log.log(Level.INFO, this.name + message);
            }
        }
    }

    public void info(Object message, Throwable error) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.INFO, this.name + LoggingUtil.classAndMethod() + " " + message, error);
            } else {
                this.log.log(Level.INFO, this.name + message, error);
            }
        }
    }

    public void warning(Object message) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, this.name + message);
        }
    }

    public void warning(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(Level.WARNING)) {
            this.log.log(Level.WARNING, this.name + message, throwable);
        }
    }

    public void error(Object message) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, this.name + message);
        }
    }

    public void error(Object message, Throwable throwable) {
        if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, this.name + message, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.FINEST);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARNING);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.SEVERE);
    }

    private boolean isLevelEnabled(Level level) {
        return this.log != null && this.log.isLoggable(level);
    }

    private static String classAndMethod() {
        String result = null;
        Throwable t = new Throwable();
        StackTraceElement[] ste = t.getStackTrace();
        if (ste != null && ste.length > 2) {
            String className;
            int index;
            StackTraceElement element = ste[2];
            if (element.getClassName().endsWith(LoggingUtil.class.getName())) {
                element = ste[3];
            }
            if ((index = (className = element.getClassName()).lastIndexOf(".")) > -1) {
                className = className.substring(index + 1, className.length());
            }
            result = className + "." + element.getMethodName() + "()";
        }
        return result;
    }

    public String getName() {
        return this.log.getName();
    }

    public Logger getLogger() {
        return this.log;
    }
}

