/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.agent;

import java.io.Serializable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.ow2.petals.communication.jndi.agent.JNDIAgentService;
import org.ow2.petals.communication.jndi.agent.msg.request.RegistryRequest;
import org.ow2.petals.communication.jndi.agent.util.RegistryUtil;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJNDIAgentServiceImpl
implements JNDIAgentService {
    public static final String INITIAL_CONTEXT = "/";
    protected DomainConfiguration domainConfiguration;
    protected LoggingUtil log;
    protected Map<String, Map<String, Serializable>> data;
    protected RegistryUtil registryUtil;

    @Override
    public Object processRequest(RegistryRequest registryRequest) throws NamingException {
        this.log.start((Object)registryRequest.getType());
        Object object = null;
        switch (registryRequest.getType()) {
            case bind: {
                this.registryUtil.bind(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.getArg3());
                break;
            }
            case createSubcontext: {
                object = this.registryUtil.createSubcontext(registryRequest.getArg1(), registryRequest.getArg2());
                break;
            }
            case destroySubcontext: {
                this.registryUtil.destroySubcontext(registryRequest.getArg1(), registryRequest.getArg2());
                break;
            }
            case list: {
                object = this.registryUtil.list(registryRequest.getArg1(), registryRequest.getArg2());
                break;
            }
            case listBindings: {
                object = this.registryUtil.listBindings(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.isLocalConnection());
                break;
            }
            case lookup: {
                object = this.registryUtil.lookup(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.isLocalConnection());
                break;
            }
            case lookupLink: {
                object = this.registryUtil.lookupLink(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.isLocalConnection());
                break;
            }
            case rebind: {
                this.registryUtil.rebind(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.getArg3());
                break;
            }
            case rename: {
                this.registryUtil.rename(registryRequest.getArg1(), registryRequest.getArg2(), registryRequest.getArg3(), registryRequest.isLocalConnection());
                break;
            }
            case unbind: {
                this.registryUtil.unbind(registryRequest.getArg1(), registryRequest.getArg2());
                break;
            }
        }
        this.log.end();
        return object;
    }

    public LoggingUtil getLog() {
        return this.log;
    }

    public DomainConfiguration getDomainConfiguration() {
        return this.domainConfiguration;
    }

    public abstract boolean containsContext(String var1) throws ServiceUnavailableException;

    public abstract Map<String, Serializable> getContext(String var1) throws ServiceUnavailableException;

    public abstract void removeContext(String var1) throws ServiceUnavailableException;
}

