/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.client.naming;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.petals.communication.jndi.agent.msg.request.BindRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.CreateSubcontextRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.DestroySubcontextRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.ListBindingsRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.ListRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.LookupLinkRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.LookupRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.RebindRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.RenameRequest;
import org.ow2.petals.communication.jndi.agent.msg.request.UnbindRequest;
import org.ow2.petals.communication.jndi.client.naming.JNDINameParser;
import org.ow2.petals.communication.jndi.client.naming.NamingConnection;
import org.ow2.petals.communication.jndi.client.naming.NamingEnumerationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingContextImpl
implements Serializable,
Context {
    private static final long serialVersionUID = 3500860311186808637L;
    protected String contextName;
    protected Map<String, Object> env;
    protected NamingConnection namingConnection;
    private boolean localConnection;

    public NamingContextImpl(Map<String, Object> map, NamingConnection namingConnection, String string, boolean bl) {
        this.env = map;
        this.namingConnection = namingConnection;
        this.contextName = string;
        this.localConnection = bl;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        Object object2 = this.env.get(string);
        this.env.put(string, object);
        return object2;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.namingConnection.send(new BindRequest(this.contextName, string, object, this.localConnection));
    }

    @Override
    public void close() throws NamingException {
        this.env = null;
        this.namingConnection = null;
        this.contextName = null;
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (name == null) {
            throw new NamingException("Name must be non null");
        }
        if (name2 == null) {
            throw new NamingException("Prefix must be non null");
        }
        return new CompositeName(String.valueOf(name2.toString()) + name.toString());
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        if (string == null) {
            throw new NamingException("Name must be non null");
        }
        if (string2 == null) {
            throw new NamingException("Prefix must be non null");
        }
        return String.valueOf(string2) + string;
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        Object object = this.namingConnection.send(new CreateSubcontextRequest(this.contextName, string, this.localConnection));
        NamingContextImpl namingContextImpl = new NamingContextImpl(this.env, this.namingConnection, (String)object, this.localConnection);
        return namingContextImpl;
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        this.namingConnection.send(new DestroySubcontextRequest(this.contextName, string, this.localConnection));
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return (Hashtable)this.env;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.contextName;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new JNDINameParser();
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return new JNDINameParser();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        NameClassPair[] nameClassPairArray = (NameClassPair[])this.namingConnection.send(new ListRequest(this.contextName, string, this.localConnection));
        return new NamingEnumerationImpl<NameClassPair>(nameClassPairArray);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        Binding[] bindingArray = (Binding[])this.namingConnection.send(new ListBindingsRequest(this.contextName, string, this.localConnection));
        return new NamingEnumerationImpl<Binding>(bindingArray);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String string) throws NamingException {
        Object object = this.namingConnection.send(new LookupRequest(this.contextName, string, this.localConnection));
        return object;
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        Object object = this.namingConnection.send(new LookupLinkRequest(this.contextName, string, this.localConnection));
        return object;
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.namingConnection.send(new RebindRequest(this.contextName, string, object, this.localConnection));
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        Object object = this.env.get(string);
        if (this.env.containsKey(string)) {
            this.env.remove(string);
        }
        return object;
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        this.namingConnection.send(new RenameRequest(this.contextName, string, string2, this.localConnection));
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void unbind(String string) throws NamingException {
        this.namingConnection.send(new UnbindRequest(this.contextName, string, this.localConnection));
    }
}

