/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.lifecycle;

import java.io.File;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.management.LifeCycleMBean;
import org.ow2.petals.container.lifecycle.Installer;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.descriptor.original.generated.ServiceUnit;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.util.PackageHelper;

public class ServiceUnitLifeCycle
implements LifeCycleMBean {
    private AdminService adminService;
    private ServiceUnit serviceUnit;
    private String serviceUnitRootPath;
    private Jbi jbiDescriptor;
    private ServiceUnitManager serviceUnitManager;
    private String name;
    protected String state;

    public ServiceUnitLifeCycle(ServiceUnit serviceUnit, String string, AdminService adminService) {
        this.adminService = adminService;
        this.serviceUnit = serviceUnit;
        this.serviceUnitRootPath = string;
        if (serviceUnit != null && serviceUnit.getIdentification() != null) {
            this.name = serviceUnit.getIdentification().getName();
        }
        this.state = "Shutdown";
    }

    public ServiceUnitManager getServiceUnitManager() {
        Installer installer;
        if (this.serviceUnitManager == null && (installer = this.adminService.getInstallerByName(this.serviceUnit.getTarget().getComponentName())) != null) {
            this.serviceUnitManager = installer.getComponent().getServiceUnitManager();
        }
        return this.serviceUnitManager;
    }

    public String getTargetComponentName() {
        return this.serviceUnit.getTarget().getComponentName();
    }

    public String getServiceUnitRootPath() {
        return this.serviceUnitRootPath;
    }

    public String getSuName() {
        return this.name;
    }

    public synchronized Jbi getServiceUnitDescriptor() {
        if (this.jbiDescriptor == null) {
            try {
                this.jbiDescriptor = PackageHelper.loadDescriptor(new File(this.serviceUnitRootPath));
            }
            catch (Exception exception) {}
        }
        return this.jbiDescriptor;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws DeploymentException {
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getServiceUnitManager().getClass().getClassLoader());
                this.getServiceUnitManager().init(this.name, this.serviceUnitRootPath);
            }
            catch (DeploymentException deploymentException) {
                this.state = "Unknown";
                throw deploymentException;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var2_4 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.state = "Stopped";
            return;
        }
    }

    public String getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutDown() throws JBIException {
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getServiceUnitManager().getClass().getClassLoader());
                this.getServiceUnitManager().shutDown(this.name);
            }
            catch (DeploymentException deploymentException) {
                this.state = "Unknown";
                throw deploymentException;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var2_4 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.state = "Shutdown";
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws JBIException {
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getServiceUnitManager().getClass().getClassLoader());
                this.getServiceUnitManager().start(this.name);
            }
            catch (DeploymentException deploymentException) {
                this.state = "Unknown";
                throw deploymentException;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var2_4 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.state = "Started";
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() throws JBIException {
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getServiceUnitManager().getClass().getClassLoader());
                this.getServiceUnitManager().stop(this.name);
            }
            catch (DeploymentException deploymentException) {
                this.state = "Unknown";
                throw deploymentException;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            throw throwable;
        }
        {
            Object var2_4 = null;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.state = "Stopped";
            return;
        }
    }
}

