/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.recovery;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.container.ContainerService;
import org.ow2.petals.container.lifecycle.ServiceAssemblyLifeCycle;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.TaskProcessor;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.recovery.SystemRecoveryService;
import org.ow2.petals.jbi.management.task.deployment.DeploymentTaskFactory;
import org.ow2.petals.jbi.management.task.installation.InstallationTaskFactory;
import org.ow2.petals.jbi.management.util.PackageHelper;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.repository.RepositoryServiceImpl;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SystemRecoveryService.class)})
public class SystemRecoveryServiceImpl
implements BindingController,
LifeCycleController,
SystemRecoveryService {
    protected LoggingUtil log;
    private DeploymentTaskFactory deploymentTaskFactory;
    protected InstallationTaskFactory installationTaskFactory;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    protected EndpointRegistry endpointRegistry;
    @Requires(name="admin", signature=AdminService.class)
    protected AdminService adminService;
    @Requires(name="router", signature=RouterService.class)
    protected RouterService router;
    @Requires(name="repository", signature=RepositoryService.class)
    protected RepositoryService repositoryService;
    @Requires(name="systemstate", signature=SystemStateService.class)
    protected SystemStateService systemStateService;
    @Requires(name="container", signature=ContainerService.class)
    protected ContainerService container;
    private ThreadPoolExecutor threadPoolExecutor;
    private CompletionService<RecoveryResult> ecs;

    public String getFcState() {
        return null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void recoverAllEntities() throws ManagementException {
        this.log.start();
        this.recoverAllSharedLibrary();
        this.recoverAllComponent();
        this.recoverAllServiceAssembly();
        this.log.end();
    }

    private void recoverAllComponent() throws ManagementException {
        this.log.start();
        final ArrayList<File> arrayList = new ArrayList<File>((Collection)Arrays.asList(this.repositoryService.getComponentsDirectory().listFiles()));
        List<Component> list = this.systemStateService.getComponentStateHolders();
        int n = 0;
        for (final Component component : list) {
            Callable<RecoveryResult> callable = new Callable<RecoveryResult>(){

                @Override
                public RecoveryResult call() throws ManagementException {
                    File file;
                    URL uRL = null;
                    Jbi jbi = null;
                    try {
                        uRL = new URL(component.getInstallURL());
                        jbi = PackageHelper.loadDescriptor(component.getName(), RepositoryServiceImpl.EntityType.COMPONENT_TYPE, SystemRecoveryServiceImpl.this.repositoryService);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("A component consistency is corrupted: ");
                        stringBuffer.append(component.getName());
                        stringBuffer.append("\nCaused by: " + exception.getMessage());
                        try {
                            SystemRecoveryServiceImpl.this.systemStateService.updateComponentLifeCycleState(component.getName(), "Unknown");
                            SystemRecoveryServiceImpl.this.systemStateService.updateComponentInstallationState(component.getName(), "Unknown");
                            stringBuffer.append("\nIts state changes to UNKNOWN");
                        }
                        catch (Exception exception2) {}
                        stringBuffer.append("\nPlease check the repository consistency.");
                        throw new ManagementException(stringBuffer.toString());
                    }
                    SystemRecoveryServiceImpl.this.recoverComponent(uRL, jbi, component.getInstallState(), component.getLifecycleState(), component.getName());
                    if (arrayList != null && (file = new File(uRL.getPath()).getParentFile()).exists()) {
                        arrayList.remove(file);
                    }
                    return new RecoveryResult(component.getName());
                }
            };
            this.log.debug((Object)("Recover Component '" + component.getName() + "'"));
            this.ecs.submit(callable);
            ++n;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                RecoveryResult recoveryResult = this.ecs.take().get();
                this.log.debug((Object)("Component '" + recoveryResult.jbiArtifactName + "' recovered"));
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"Component recovering has been interrupted");
            }
            catch (ExecutionException executionException) {
                this.log.error((Object)executionException.getMessage(), (Throwable)executionException);
            }
            ++n2;
        }
        this.moveUnknownDirsToLostPlusFoundDir(arrayList);
        this.log.end();
    }

    public void recoverAllServiceAssembly() throws ManagementException {
        this.log.start();
        final ArrayList<File> arrayList = new ArrayList<File>((Collection)Arrays.asList(this.repositoryService.getServiceAssembliesDirectory().listFiles()));
        List<ServiceAssembly> list = this.systemStateService.getServiceAssemblyStateHolders();
        for (final ServiceAssembly serviceAssembly : list) {
            Callable<RecoveryResult> callable = new Callable<RecoveryResult>(){

                @Override
                public RecoveryResult call() throws ManagementException {
                    File file;
                    URL uRL = null;
                    Jbi jbi = null;
                    try {
                        uRL = new URL(serviceAssembly.getInstallURL());
                        jbi = PackageHelper.loadDescriptor(serviceAssembly.getName(), RepositoryServiceImpl.EntityType.SA_TYPE, SystemRecoveryServiceImpl.this.repositoryService);
                    }
                    catch (Exception exception) {
                        StringBuffer stringBuffer = new StringBuffer("A service assembly consistency is corrupted: ");
                        stringBuffer.append(serviceAssembly.getName());
                        stringBuffer.append("\nCaused by: " + exception.getMessage());
                        try {
                            SystemRecoveryServiceImpl.this.systemStateService.updateServiceAssemblyState(serviceAssembly.getName(), "Unknown");
                            stringBuffer.append("\nIts state changes to UNKNOWN");
                        }
                        catch (Exception exception2) {}
                        stringBuffer.append("\nPlease check the repository consistency");
                        throw new ManagementException(stringBuffer.toString());
                    }
                    SystemRecoveryServiceImpl.this.recoverServiceAssembly(uRL, jbi, serviceAssembly.getLifecycleState());
                    if (arrayList != null && (file = new File(uRL.getPath()).getParentFile()).exists()) {
                        arrayList.remove(file);
                    }
                    return new RecoveryResult(serviceAssembly.getName());
                }
            };
            this.log.debug((Object)("Recover Service Assembly '" + serviceAssembly.getName() + "'"));
            this.ecs.submit(callable);
        }
        int n = 0;
        while (n < list.size()) {
            try {
                RecoveryResult recoveryResult = this.ecs.take().get();
                this.log.debug((Object)("Service Assembly '" + recoveryResult.jbiArtifactName + "' recovered"));
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"Service Assembly recovering has been interrupted");
            }
            catch (ExecutionException executionException) {
                this.log.error((Object)executionException.getMessage(), (Throwable)executionException);
            }
            ++n;
        }
        this.moveUnknownDirsToLostPlusFoundDir(arrayList);
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("admin")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        if (string.equals("repository")) {
            if (!RepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RepositoryService.class.getName());
            }
            this.repositoryService = (RepositoryService)object;
            return;
        }
        if (string.equals("systemstate")) {
            if (!SystemStateService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SystemStateService.class.getName());
            }
            this.systemStateService = (SystemStateService)object;
            return;
        }
        if (string.equals("container")) {
            if (!ContainerService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ContainerService.class.getName());
            }
            this.container = (ContainerService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("endpoint");
        arrayList.add("admin");
        arrayList.add("router");
        arrayList.add("repository");
        arrayList.add("systemstate");
        arrayList.add("container");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("admin")) {
            return this.adminService;
        }
        if (string.equals("router")) {
            return this.router;
        }
        if (string.equals("repository")) {
            return this.repositoryService;
        }
        if (string.equals("systemstate")) {
            return this.systemStateService;
        }
        if (string.equals("container")) {
            return this.container;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("admin")) {
            this.adminService = null;
            return;
        }
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        if (string.equals("repository")) {
            this.repositoryService = null;
            return;
        }
        if (string.equals("systemstate")) {
            this.systemStateService = null;
            return;
        }
        if (string.equals("container")) {
            this.container = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void recoverAllSharedLibrary() throws ManagementException {
        this.log.start();
        final ArrayList<File> arrayList = new ArrayList<File>((Collection)Arrays.asList(this.repositoryService.getSharedLibrariesDirectory().listFiles()));
        List<SharedLibrary> list = this.systemStateService.getSharedLibraryStateHolders();
        for (final SharedLibrary sharedLibrary : list) {
            Callable<RecoveryResult> callable = new Callable<RecoveryResult>(){

                @Override
                public RecoveryResult call() throws ManagementException {
                    Object object;
                    URL uRL = null;
                    try {
                        uRL = new URL(sharedLibrary.getInstallURL());
                        object = PackageHelper.loadDescriptor(String.valueOf(sharedLibrary.getName()) + "-" + sharedLibrary.getVersion(), RepositoryServiceImpl.EntityType.SL_TYPE, SystemRecoveryServiceImpl.this.repositoryService);
                        SystemRecoveryServiceImpl.this.recoverSharedLib(uRL, (Jbi)object);
                    }
                    catch (Exception exception) {
                        String string = "A Shared Library can't be recovered : " + sharedLibrary.getName() + "\nPlease check the repository consistency";
                        SystemRecoveryServiceImpl.this.log.error((Object)string, (Throwable)exception);
                        throw new ManagementException(String.valueOf(string) + "Cause: " + exception.getCause());
                    }
                    if (arrayList != null && ((File)(object = new File(uRL.getPath()).getParentFile())).exists()) {
                        arrayList.remove(object);
                    }
                    return new RecoveryResult(sharedLibrary.getName());
                }
            };
            this.log.debug((Object)("Recover Shared Library '" + sharedLibrary.getName() + "'"));
            this.ecs.submit(callable);
        }
        int n = 0;
        while (n < list.size()) {
            try {
                RecoveryResult recoveryResult = this.ecs.take().get();
                this.log.debug((Object)("Shared Library '" + recoveryResult.jbiArtifactName + "' recovered"));
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"Shared Library recovering has been interrupted");
            }
            catch (ExecutionException executionException) {
                this.log.error((Object)executionException.getMessage(), (Throwable)executionException);
            }
            ++n;
        }
        this.moveUnknownDirsToLostPlusFoundDir(arrayList);
        this.log.end();
    }

    protected void moveUnknownDirsToLostPlusFoundDir(List<File> list) {
        if (list != null) {
            for (File file : list) {
                boolean bl;
                if (file.isFile()) continue;
                if (!file.exists()) {
                    this.log.warning((Object)("The unknown dir (" + file.getAbsolutePath() + ") doesn't exist."));
                }
                if (bl = file.renameTo(new File(this.repositoryService.getLostPlusFoundDirectory(), file.getName()))) continue;
                this.log.warning((Object)("Failed to move unknown directory (" + file.getAbsolutePath() + ") to lost+found directory"));
            }
        }
    }

    protected void recoverComponent(URL uRL, Jbi jbi, String string, String string2, String string3) throws ManagementException {
        this.log.start();
        Context context = this.createRecoveryContext(jbi, uRL);
        this.recoverComponent(context);
        this.log.info((Object)("Installer of the component '" + context.getDescriptor().getComponent().getIdentification().getName() + "' loaded"));
        try {
            if ("Installed".equals(string)) {
                MBeanServer mBeanServer = this.adminService.getMBeanServer();
                Object[] objectArray = new Object[]{};
                String[] stringArray = new String[]{};
                ObjectName objectName = (ObjectName)mBeanServer.invoke(context.getInstallerObjectName(), "install", objectArray, stringArray);
                if ("Stopped".equals(string2)) {
                    mBeanServer.invoke(objectName, "start", objectArray, stringArray);
                    mBeanServer.invoke(objectName, "stop", objectArray, stringArray);
                } else if ("Started".equals(string2)) {
                    mBeanServer.invoke(objectName, "start", objectArray, stringArray);
                } else if ("Unknown".equals(string2)) {
                    this.log.warning((Object)("The component '" + string3 + "' was in state " + "Unknown" + ", it is recovered in state " + "Shutdown"));
                    try {
                        this.systemStateService.updateComponentLifeCycleState(string3, "Shutdown");
                    }
                    catch (Exception exception) {
                        this.log.error((Object)("The component '" + string3 + "' failed to be recovered at state " + "Shutdown"), (Throwable)exception);
                    }
                }
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ManagementException("Failed to recover Component '" + string3 + "'", instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            throw new ManagementException("Failed to recover Component '" + string3 + "'", mBeanException);
        }
        catch (ReflectionException reflectionException) {
            throw new ManagementException("Failed to recover Component '" + string3 + "'", reflectionException);
        }
        this.log.end();
    }

    protected Context createRecoveryContext(Jbi jbi, URL uRL) {
        Context context = new Context();
        context.setDescriptor(jbi);
        context.setInstallUrl(uRL);
        context.setUnzipRoot(new File(uRL.getPath()));
        return context;
    }

    protected void recoverServiceAssembly(URL uRL, Jbi jbi, String string) throws ManagementException {
        this.log.start();
        String string2 = jbi.getServiceAssembly().getIdentification().getName();
        try {
            Context context = this.createDeploymentContext(uRL, jbi);
            this.recoverSA(context);
            if ("Stopped".equals(string)) {
                ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string2);
                serviceAssemblyLifeCycle.start();
                serviceAssemblyLifeCycle.stop();
            } else if ("Started".equals(string)) {
                ServiceAssemblyLifeCycle serviceAssemblyLifeCycle = this.adminService.getServiceAssemblyByName(string2);
                serviceAssemblyLifeCycle.start();
            } else if ("Unknown".equals(string)) {
                this.log.warning((Object)("The Service Assembly '" + string2 + "' was in state " + "Unknown" + ", it is recovered in state " + "Shutdown"));
                try {
                    this.systemStateService.updateServiceAssemblyState(string2, "Shutdown");
                }
                catch (Exception exception) {
                    this.log.error((Object)("The Service Assembly '" + string2 + "' failed to be recovered at state " + "Shutdown"), (Throwable)exception);
                }
            }
        }
        catch (JBIException jBIException) {
            throw new ManagementException("Failed to recover Service Assembly '" + string2 + "'", jBIException);
        }
        this.log.end();
    }

    protected Context createDeploymentContext(URL uRL, Jbi jbi) {
        Context context = new Context();
        context.setUnzipRoot(new File(uRL.getPath()));
        context.setDescriptor(jbi);
        return context;
    }

    protected void recoverSharedLib(URL uRL, Jbi jbi) throws ManagementException {
        this.log.start();
        Context context = this.createRecoveryContext(jbi, uRL);
        this.recoverSharedLib(context);
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.JBI-Management.SystemRecoveryService"));
        this.log.start();
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        this.installationTaskFactory = new InstallationTaskFactory(this.systemStateService, this.repositoryService, this.log, this.adminService, this.router, this.container, containerConfiguration.getRootDirectoryPath());
        this.deploymentTaskFactory = new DeploymentTaskFactory(this.endpointRegistry, null, this.systemStateService, this.repositoryService, this.log, this.adminService, this.container, containerConfiguration.getRootDirectoryPath());
        this.threadPoolExecutor = new ThreadPoolExecutor(containerConfiguration.getRecoveryCorePoolSize(), containerConfiguration.getRecoveryMaxPoolSize(), containerConfiguration.getRecoveryKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.ecs = new ExecutorCompletionService<RecoveryResult>(this.threadPoolExecutor);
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.threadPoolExecutor.shutdownNow();
    }

    private void recoverSA(Context context) throws ManagementException {
        Jbi jbi = context.getDescriptor();
        TaskProcessor taskProcessor = this.createSARecoveryProcessor(context);
        Throwable throwable = taskProcessor.process();
        if (throwable != null) {
            throw new ManagementException("Failed to recover Service Assembly '" + jbi.getServiceAssembly().getIdentification().getName() + "'", throwable);
        }
    }

    private TaskProcessor createSARecoveryProcessor(Context context) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.deploymentTaskFactory.getSaCheckPackageTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getCreateXMLDeploymentResultTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRetrieveSAAndSUInstallRootsTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterSALifeCycleTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getDeployAllSUTask());
        taskProcessor.addTask(this.deploymentTaskFactory.getRegisterAllConnectionTask());
        return taskProcessor;
    }

    private void recoverComponent(Context context) throws ManagementException {
        Jbi jbi = context.getDescriptor();
        TaskProcessor taskProcessor = this.createComponentRecoveryProcessor(context);
        Throwable throwable = taskProcessor.process();
        if (throwable != null) {
            throw new ManagementException("Failed to recover Component '" + jbi.getComponent().getIdentification().getName() + "'", throwable);
        }
    }

    private TaskProcessor createComponentRecoveryProcessor(Context context) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.installationTaskFactory.getRegisterComponentInSLTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateAndRegisterInstallerMBeanTask());
        return taskProcessor;
    }

    private void recoverSharedLib(Context context) throws ManagementException {
        Jbi jbi = context.getDescriptor();
        TaskProcessor taskProcessor = this.createSLRecoveryProcessor(context);
        Throwable throwable = taskProcessor.process();
        if (throwable != null) {
            throw new ManagementException("Failed to recover Shared Library '" + jbi.getSharedLibrary().getIdentification().getName() + "'", throwable);
        }
    }

    private TaskProcessor createSLRecoveryProcessor(Context context) {
        TaskProcessor taskProcessor = new TaskProcessor(context, this.log);
        taskProcessor.addTask(this.installationTaskFactory.getSLCheckPackageTask());
        taskProcessor.addTask(this.installationTaskFactory.getCreateSLClassloaderTask());
        return taskProcessor;
    }

    private class RecoveryResult {
        protected final String jbiArtifactName;

        public RecoveryResult(String string) {
            this.jbiArtifactName = string;
        }
    }
}

