/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.management.transaction.TransactionManagerImpl;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.util.LoggingUtil;

public class DeliveryChannelImpl
implements DeliveryChannel {
    private final ComponentContext componentContext;
    private final LoggingUtil log;
    private final Logger logger;
    protected boolean opened = true;

    public DeliveryChannelImpl(ComponentContext componentContext) {
        this.logger = componentContext.getLogger();
        this.log = new LoggingUtil(this.logger);
        this.componentContext = componentContext;
    }

    private static final void checkMessageExchange(MessageExchangeWrapper messageExchangeWrapper) throws MessagingException {
        if (messageExchangeWrapper == null) {
            throw new MessagingException("MessageExchange is null");
        }
        MessageExchangeWrapper messageExchangeWrapper2 = messageExchangeWrapper;
        if (messageExchangeWrapper2.getMessageExchange().isTerminated()) {
            throw new MessagingException("MessageExchange is terminated, it can not be sent any more");
        }
    }

    public MessageExchange accept() throws MessagingException {
        this.log.call();
        MessageExchange messageExchange = this.poll(-1L);
        return messageExchange;
    }

    public MessageExchange accept(long l) throws MessagingException {
        this.log.call((Object)l);
        if (l < 0L) {
            throw new MessagingException("Timeout must be positive");
        }
        MessageExchange messageExchange = this.poll(l);
        return messageExchange;
    }

    public void checkDeliveryChannelIsOpened() throws MessagingException {
        if (!this.opened) {
            throw new MessagingException("DeliveryChannel is closed");
        }
    }

    public synchronized void close() throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        this.opened = false;
        this.log.end();
    }

    public MessageExchangeFactory createExchangeFactory() {
        this.log.call();
        PersistedContextualMessageExchangeFactoryImpl persistedContextualMessageExchangeFactoryImpl = PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactory(this.componentContext.getAddress(), this.logger);
        return persistedContextualMessageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(QName qName) {
        this.log.call((Object)qName);
        PersistedContextualMessageExchangeFactoryImpl persistedContextualMessageExchangeFactoryImpl = PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForInterface(this.componentContext.getAddress(), this.logger, qName);
        return persistedContextualMessageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint serviceEndpoint) {
        this.log.call((Object)serviceEndpoint);
        PersistedContextualMessageExchangeFactoryImpl persistedContextualMessageExchangeFactoryImpl = PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForEndpoint(this.componentContext.getAddress(), this.logger, serviceEndpoint);
        return persistedContextualMessageExchangeFactoryImpl;
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName qName) {
        this.log.call((Object)qName);
        PersistedContextualMessageExchangeFactoryImpl persistedContextualMessageExchangeFactoryImpl = PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForService(this.componentContext.getAddress(), this.logger, qName);
        return persistedContextualMessageExchangeFactoryImpl;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void send(MessageExchange messageExchange) throws MessagingException {
        this.log.call((Object)("Exchange Id:" + messageExchange.getExchangeId()));
        this.sendExchange((MessageExchangeWrapper)messageExchange, 0L, false);
    }

    public boolean sendSync(MessageExchange messageExchange) throws MessagingException {
        return this.sendSync(messageExchange, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public boolean sendSync(MessageExchange var1_1, long var2_2) throws MessagingException {
        block5: {
            this.log.call((Object)("Exchange Id:" + var1_1.getExchangeId() + " - Timeout:" + var2_2));
            var4_3 = false;
            var5_4 = (MessageExchangeWrapper)var1_1;
            try {
                this.sendExchange(var5_4, var2_2, true);
                if (var5_4.isTimeout()) {
                    var5_4.setTimeout(false);
                    var4_3 = true;
                }
                break block5;
            }
            catch (MessagingException var6_5) {
                this.log.debug((Object)var6_5.getMessage());
                var5_4.setStatus(ExchangeStatus.ERROR);
                var5_4.getMessageExchange().setTerminated(true);
                var7_6 = var6_5.getCause();
                ** while (var7_6 != null)
            }
lbl-1000:
            // 1 sources

            {
                if (var7_6 instanceof InterruptedException) {
                    this.log.end();
                    return false;
                }
                var7_6 = var7_6.getCause();
                continue;
            }
lbl21:
            // 1 sources

            throw var6_5;
        }
        this.log.end();
        return var4_3 == false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logMessage(MessageExchangeWrapper messageExchangeWrapper) {
        Logger logger = null;
        try {
            block16: {
                Object object;
                Object object2;
                NormalizedMessage normalizedMessage;
                block17: {
                    block14: {
                        InputStream inputStream;
                        Object object3;
                        block15: {
                            logger = this.componentContext.getLogger("", null);
                            if (!logger.isLoggable(Level.FINEST)) return;
                            if (!ExchangeStatus.ACTIVE.equals(messageExchangeWrapper.getStatus())) break block16;
                            normalizedMessage = messageExchangeWrapper.getMessage("out");
                            String string = "out";
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchangeWrapper.getFault();
                                string = "Fault";
                            }
                            if (normalizedMessage == null) {
                                normalizedMessage = messageExchangeWrapper.getMessage("in");
                                string = "in";
                            }
                            logger.finest("Message " + string + " with Id '" + messageExchangeWrapper.getExchangeId() + "' to send");
                            logger.finest("Operation : " + messageExchangeWrapper.getOperation());
                            logger.finest("MEP : " + messageExchangeWrapper.getPattern());
                            object2 = messageExchangeWrapper.getPropertyNames().iterator();
                            while (true) {
                                if (!object2.hasNext()) break;
                                object3 = object2.next();
                                logger.finest("Exchange property '" + object3 + "' : " + messageExchangeWrapper.getProperty((String)object3));
                            }
                            object2 = normalizedMessage.getPropertyNames().iterator();
                            while (true) {
                                if (!object2.hasNext()) {
                                    object3 = normalizedMessage.getContent();
                                    if (object3 == null) break block14;
                                    if (object3 instanceof StreamSource) {
                                        object = (StreamSource)object3;
                                        inputStream = ((StreamSource)object).getInputStream();
                                        object2 = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(((StreamSource)object).getReader()));
                                    }
                                    break block15;
                                }
                                object3 = object2.next();
                                logger.finest("Message property '" + object3 + "' : " + normalizedMessage.getProperty((String)object3));
                            }
                            normalizedMessage.setContent((Source)new StreamSource(object2.fork()));
                            object3 = new StreamSource(object2.fork());
                        }
                        object2 = Transformers.takeTransformer();
                        ((Transformer)object2).setOutputProperty("omit-xml-declaration", "no");
                        ((Transformer)object2).setOutputProperty("method", "xml");
                        ((Transformer)object2).setOutputProperty("encoding", Charset.defaultCharset().name());
                        object = new ByteArrayOutputStream();
                        try {
                            ((Transformer)object2).transform((Source)object3, new StreamResult((OutputStream)object));
                        }
                        catch (Throwable throwable) {
                            inputStream = null;
                            Transformers.releaseTransformer((Transformer)object2);
                            throw throwable;
                        }
                        {
                            inputStream = null;
                        }
                        Transformers.releaseTransformer((Transformer)object2);
                        logger.finest("Message Content : " + new String(((ByteArrayOutputStream)object).toByteArray()));
                        break block17;
                    }
                    logger.finest("Message Content is null");
                }
                object = normalizedMessage.getAttachmentNames().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        return;
                    }
                    object2 = object.next();
                    logger.finest("Got a message attachment named '" + object2 + "'");
                }
            }
            if (ExchangeStatus.DONE.equals(messageExchangeWrapper.getStatus())) {
                logger.finest("Message acknowledgement DONE with Id '" + messageExchangeWrapper.getExchangeId() + "' to send");
                return;
            }
            logger.finest("Message acknowledgement ERROR with Id '" + messageExchangeWrapper.getExchangeId() + "' to send");
            logger.finest("Message Error : " + messageExchangeWrapper.getError().getMessage());
            return;
        }
        catch (Exception exception) {
            if (logger == null) return;
            logger.fine("Failed to log the content of the message to send: " + exception.getMessage());
        }
    }

    private MessageExchange poll(long l) throws MessagingException {
        this.log.start();
        this.checkDeliveryChannelIsOpened();
        MessageExchangeWrapper messageExchangeWrapper = null;
        try {
            messageExchangeWrapper = this.componentContext.getRouter().receive(this.componentContext, l);
        }
        catch (RoutingException routingException) {
            throw new MessagingException((Throwable)((Object)routingException));
        }
        if (messageExchangeWrapper != null && this.componentContext.getTransactionManager() != null) {
            TransactionManagerImpl.decodeTransactionContext(messageExchangeWrapper);
        }
        this.log.end();
        return messageExchangeWrapper;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendExchange(MessageExchangeWrapper messageExchangeWrapper, long l, boolean bl) throws MessagingException {
        this.checkDeliveryChannelIsOpened();
        DeliveryChannelImpl.checkMessageExchange(messageExchangeWrapper);
        this.logMessage(messageExchangeWrapper);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (!ExchangeStatus.ACTIVE.equals(messageExchangeWrapper.getStatus())) {
                    messageExchangeWrapper.setTerminated(true);
                    if (bl) {
                        throw new MessagingException("Sending an acknowledgment in synchronous mode is forbidden");
                    }
                }
                if (this.componentContext.getTransactionManager() != null) {
                    TransactionManagerImpl.encodeTransactionContext(messageExchangeWrapper);
                }
                if (bl) {
                    this.componentContext.getRouter().sendSync(this.componentContext, messageExchangeWrapper, l);
                    if (!messageExchangeWrapper.isTimeout() && this.componentContext.getTransactionManager() != null) {
                        TransactionManagerImpl.decodeTransactionContext(messageExchangeWrapper);
                    }
                } else {
                    this.componentContext.getRouter().send(this.componentContext, messageExchangeWrapper);
                }
            }
            catch (JBIException jBIException) {
                throw new MessagingException((Throwable)jBIException);
            }
            catch (SystemException systemException) {
                throw new MessagingException((Throwable)systemException);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var7_9 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        this.log.end();
    }
}

