/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module.endpoint;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.endpoint.WeightedEndpoint;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointOrderer {
    private LoggingUtil log;
    private ContainerConfiguration containerConfiguration;
    private TopologyService topologyService;
    private Random random;

    public EndpointOrderer(LoggingUtil loggingUtil, ContainerConfiguration containerConfiguration, TopologyService topologyService) {
        this.log = loggingUtil;
        this.containerConfiguration = containerConfiguration;
        this.topologyService = topologyService;
        this.random = new Random();
    }

    public final List<ServiceEndpoint> orderEndpoints(List<ServiceEndpoint> list, List<Object> list2) throws RoutingException {
        float f;
        float f2;
        float f3;
        String string;
        Object object;
        try {
            object = list2.toArray();
            string = (String)object[0];
            f3 = ((Float)object[1]).floatValue();
            f2 = ((Float)object[2]).floatValue();
            f = ((Float)object[3]).floatValue();
        }
        catch (ClassCastException classCastException) {
            throw new RoutingException("Impossible to convert the parameters to realize the routing strategy");
        }
        object = string.equals("highest") ? this.loadHighestChoose(list, f3, f2, f) : this.loadRandomChoose(list, f3, f2, f);
        return object;
    }

    private final List<ServiceEndpoint> loadRandomChoose(List<ServiceEndpoint> list, float f, float f2, float f3) {
        TreeSet<WeightedEndpoint> treeSet = new TreeSet<WeightedEndpoint>(new Comparator<WeightedEndpoint>(){

            @Override
            public int compare(WeightedEndpoint weightedEndpoint, WeightedEndpoint weightedEndpoint2) {
                return weightedEndpoint.weight.compareTo(weightedEndpoint2.weight);
            }
        });
        this.log.debug((Object)"Apply the algorithm RANDOM");
        return this.fillSortedList(list, f, f2, f3, treeSet);
    }

    private final List<ServiceEndpoint> loadHighestChoose(List<ServiceEndpoint> list, float f, float f2, float f3) {
        final Float[] floatArray = new Float[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3)};
        TreeSet<WeightedEndpoint> treeSet = new TreeSet<WeightedEndpoint>(new Comparator<WeightedEndpoint>(){

            @Override
            public int compare(WeightedEndpoint weightedEndpoint, WeightedEndpoint weightedEndpoint2) {
                int n = floatArray[weightedEndpoint2.localization.ordinal()].compareTo(floatArray[weightedEndpoint.localization.ordinal()]);
                if (n != 0) {
                    return n;
                }
                return weightedEndpoint.weight.compareTo(weightedEndpoint2.weight);
            }
        });
        this.log.debug((Object)"Apply the algorithm HIGHEST");
        return this.fillSortedList(list, f, f2, f3, treeSet);
    }

    private List<ServiceEndpoint> fillSortedList(List<ServiceEndpoint> list, float f, float f2, float f3, SortedSet<WeightedEndpoint> sortedSet) {
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        for (ServiceEndpoint object : list) {
            if (ServiceEndpoint.EndpointType.INTERNAL.equals((Object)object.getType())) {
                String string = object.getLocation().getContainerName();
                if (string.equals(this.containerConfiguration.getName())) {
                    sortedSet.add(new WeightedEndpoint(object, f * this.random.nextFloat(), WeightedEndpoint.Localization.LOCAL));
                    continue;
                }
                if (this.topologyService.isContainerStarted(string)) {
                    sortedSet.add(new WeightedEndpoint(object, f2 * this.random.nextFloat(), WeightedEndpoint.Localization.REMOTE_ACTIVE));
                    continue;
                }
                sortedSet.add(new WeightedEndpoint(object, f3 * this.random.nextFloat(), WeightedEndpoint.Localization.REMOTE_INACTIVE));
                continue;
            }
            sortedSet.add(new WeightedEndpoint(object, f2 * this.random.nextFloat(), WeightedEndpoint.Localization.REMOTE_ACTIVE));
        }
        for (WeightedEndpoint weightedEndpoint : sortedSet) {
            arrayList.add(weightedEndpoint.endpoint);
        }
        return arrayList;
    }
}

