/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.security.AuthorizationEntry;
import org.ow2.petals.jbi.security.AuthorizationException;
import org.ow2.petals.jbi.security.DefaultAuthorizationMap;

public class DefaultAuthorizationParser {
    private static final String SERVICE_KEY = "service";
    private static final String OPERATION_KEY = "operation";
    private static final String ENDPOINT_KEY = "endpoint";
    private static final String ROLES_KEY = "roles";
    private static final String DELIMITER = ";";
    private URI uri;

    public DefaultAuthorizationParser(URI uRI) {
        this.uri = uRI;
    }

    public DefaultAuthorizationMap parse() throws AuthorizationException {
        ArrayList<AuthorizationEntry> arrayList = new ArrayList<AuthorizationEntry>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.uri)));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                AuthorizationEntry authorizationEntry;
                if (string.length() <= 0 || string.trim().charAt(0) == '#' || (authorizationEntry = this.parseEntry(string)) == null) continue;
                arrayList.add(authorizationEntry);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AuthorizationException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new AuthorizationException(iOException);
        }
        return new DefaultAuthorizationMap(arrayList);
    }

    private AuthorizationEntry parseEntry(String string) {
        if (string == null) {
            return null;
        }
        QName qName = null;
        QName qName2 = null;
        String string2 = null;
        String string3 = null;
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("endpoint=")) {
                string2 = string4.substring(ENDPOINT_KEY.length() + 1, string4.length());
                continue;
            }
            if (string4.startsWith("operation=")) {
                qName2 = QName.valueOf(string4.substring(OPERATION_KEY.length() + 1, string4.length()));
                continue;
            }
            if (string4.startsWith("service=")) {
                qName = QName.valueOf(string4.substring(SERVICE_KEY.length() + 1, string4.length()));
                continue;
            }
            if (!string4.startsWith("roles=")) continue;
            string3 = string4.substring(ROLES_KEY.length() + 1, string4.length());
        }
        if (string3 == null) {
            string3 = "";
        }
        return new AuthorizationEntry(qName, string2, qName2, string3);
    }
}

