/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import java.net.URI;

public class JndiConfiguration {
    private static final long serialVersionUID = -4815105115781154403L;
    private String jndiFactory;
    private URI jndiProviderUrl;
    private String jndiSecurityPrincipal;
    private String jndiSecurityCredentials;
    private int jndiPoolSize;
    private int jndiBatchSize;

    public String getJndiFactory() {
        return this.jndiFactory;
    }

    public URI getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }

    public String getJndiSecurityPrincipal() {
        return this.jndiSecurityPrincipal;
    }

    public String getJndiSecurityCredentials() {
        return this.jndiSecurityCredentials;
    }

    public int getJndiPoolSize() {
        return this.jndiPoolSize;
    }

    public int getJndiBatchSize() {
        return this.jndiBatchSize;
    }

    public void setJndiFactory(String string) {
        this.jndiFactory = string;
    }

    public void setJndiProviderUrl(URI uRI) {
        this.jndiProviderUrl = uRI;
    }

    public void setJndiSecurityPrincipal(String string) {
        this.jndiSecurityPrincipal = string;
    }

    public void setJndiSecurityCredentials(String string) {
        this.jndiSecurityCredentials = string;
    }

    public void setJndiPoolSize(int n) {
        this.jndiPoolSize = n;
    }

    public void setJndiBatchSize(int n) {
        this.jndiBatchSize = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.jndiFactory == null) {
            stringBuilder.append("\n\t\t\t\t  - JNDIFactory: None");
        } else {
            stringBuilder.append("\n\t\t\t\t  - JNDIFactory:" + this.jndiFactory);
        }
        if (this.jndiProviderUrl != null) {
            stringBuilder.append("\n\t\t\t\t  - JNDIProviderUrl:" + this.jndiProviderUrl);
        }
        if (this.jndiSecurityPrincipal != null) {
            stringBuilder.append("\n\t\t\t\t  - JNDISecurityPrincipal:" + this.jndiSecurityPrincipal);
        }
        if (this.jndiSecurityCredentials != null) {
            stringBuilder.append("\n\t\t\t\t  - JNDISecurityCredentials:" + this.jndiSecurityCredentials);
        }
        if (this.jndiPoolSize != 0) {
            stringBuilder.append("\n\t\t\t\t  - JNDIPool size:" + this.jndiPoolSize);
        }
        if (this.jndiBatchSize != 0) {
            stringBuilder.append("\n\t\t\t\t  - JNDIbatch size:" + this.jndiBatchSize);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.jndiFactory == null ? 0 : this.jndiFactory.hashCode());
        n = 31 * n + (this.jndiProviderUrl == null ? 0 : this.jndiProviderUrl.hashCode());
        n = 31 * n + (this.jndiSecurityPrincipal == null ? 0 : this.jndiSecurityPrincipal.hashCode());
        n = 31 * n + (this.jndiSecurityCredentials == null ? 0 : this.jndiSecurityCredentials.hashCode());
        n = 31 * n + this.jndiPoolSize + this.jndiBatchSize;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof JndiConfiguration) {
            JndiConfiguration jndiConfiguration = (JndiConfiguration)object;
            if (this.jndiFactory == null && jndiConfiguration.jndiFactory != null) {
                return false;
            }
            return this.jndiFactory.equals(jndiConfiguration.jndiFactory) && this.jndiProviderUrl.equals(jndiConfiguration.jndiProviderUrl) && this.jndiSecurityPrincipal.equals(jndiConfiguration.jndiSecurityPrincipal);
        }
        return false;
    }
}

