/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.repository.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.system.repository.artifact.LocalArtifactRepositoryService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ArtifactRepositoryService.class)})
public class FractalArtifactRepositoryService
implements BindingController,
LifeCycleController,
ArtifactRepositoryService {
    private ArtifactRepositoryService delegate;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private LoggingUtil log;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(Logger.getLogger("Petals.System.Artifact.FractalArtifactRepositoryService"));
        this.log.start();
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "artifacts");
        this.delegate = new LocalArtifactRepositoryService(file);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.end();
        this.delegate = null;
    }

    @Override
    public List<Artifact> getComponents() {
        return this.delegate.getComponents();
    }

    @Override
    public File getComponentsPath() {
        return this.delegate.getComponentsPath();
    }

    @Override
    public File getRootPath() {
        return this.delegate.getRootPath();
    }

    @Override
    public boolean addArtifact(Artifact artifact) throws PetalsException {
        return this.delegate.addArtifact(artifact);
    }

    @Override
    public List<String> getComponentsName() {
        return this.delegate.getComponentsName();
    }

    public String getFcState() {
        return null;
    }

    @Override
    public List<String> getServiceAssembliesName() {
        return this.delegate.getServiceAssembliesName();
    }

    @Override
    public File getServiceAssemblyPath() {
        return this.delegate.getServiceAssemblyPath();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public List<String> getSharedLibrariesName() {
        return this.delegate.getSharedLibrariesName();
    }

    @Override
    public File getSharedLibraryPath() {
        return this.delegate.getSharedLibraryPath();
    }

    @Override
    public List<Artifact> getServiceAssemblies() {
        return this.delegate.getServiceAssemblies();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public List<Artifact> getSharedLibraries() {
        return this.delegate.getSharedLibraries();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

