/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.ws;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.tools.ws.WebServiceException;
import org.ow2.petals.tools.ws.WebServiceHelper;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebServiceManager.class)})
public class WebServiceManagerImpl
implements BindingController,
LifeCycleController,
WebServiceManager {
    public static final String WEBSERVICE_FRACTAL_PREFIX = "webservice";
    protected LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="webservice", signature=KernelWebService.class)
    protected Map<String, Object> webServices = new Hashtable<String, Object>();
    protected Map<String, Server> servers;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RoutingException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Tools.WebServiceManager"));
        this.servers = new HashMap<String, Server>();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public String getFcState() {
        return null;
    }

    @Override
    public void exposeServices() {
        if (this.webServices != null) {
            for (String string : this.webServices.keySet()) {
                Object object = this.webServices.get(string);
                if (object instanceof KernelWebService) {
                    Object[] objectArray;
                    KernelWebService kernelWebService = (KernelWebService)object;
                    Object[] objectArray2 = objectArray = kernelWebService.getComponent().getFcInterfaces();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?>[] classArray;
                        Object object2 = objectArray2[n2];
                        boolean bl = false;
                        Class<?>[] classArray2 = classArray = object2.getClass().getInterfaces();
                        int n3 = classArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Class<?> clazz = classArray2[n4];
                            boolean bl2 = WebServiceHelper.hasWebServiceAnnotation(clazz);
                            if (bl2 && !bl) {
                                bl = this.exposeAsWebService(object2);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    continue;
                }
                this.log.info((Object)("Bad class " + object.getClass() + ", should be an instance of " + KernelWebService.class.getName()));
            }
        } else {
            this.log.info((Object)"No Web service has been defined to be exposed");
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected boolean exposeAsWebService(Object object) {
        boolean bl = true;
        JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean();
        jaxWsServerFactoryBean.setDataBinding((DataBinding)new JAXBDataBinding());
        jaxWsServerFactoryBean.setServiceBean(object);
        String string = null;
        Class<?> clazz = WebServiceHelper.getWebServiceClass(object.getClass());
        if (clazz != null) {
            string = WebServiceHelper.getWebServiceName(clazz);
            if (string == null || this.servers.get(string) != null) {
                string = object.getClass().getSimpleName();
            }
            jaxWsServerFactoryBean.setServiceClass(clazz);
        }
        String string2 = this.getURL(string);
        String string3 = String.valueOf(string2) + "?wsdl";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Service URL is " + string2));
            this.log.debug((Object)("Service WSDL is " + string3));
        }
        jaxWsServerFactoryBean.setAddress(string2);
        Server server = jaxWsServerFactoryBean.create();
        this.servers.put(string, server);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Kernel Web service '" + string + "' has been added and is available at '" + string2 + "'"));
        }
        return bl;
    }

    protected String getURL(String string) {
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        String string2 = containerConfiguration.getWebservicePrefix();
        string2 = string2 == null ? "petals/ws" : string2.trim();
        int n = containerConfiguration.getWebservicePort();
        if (n <= 0) {
            n = 9001;
        }
        return "http://" + containerConfiguration.getHost() + ":" + n + "/" + string2 + "/" + string;
    }

    @Override
    public List<String> getServicesURL() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Server server : this.servers.values()) {
            arrayList.add(server.getEndpoint().getEndpointInfo().getAddress());
        }
        return arrayList;
    }

    @Override
    public List<String> getServiceNames() {
        return Arrays.asList(this.servers.keySet().toArray(new String[this.servers.keySet().size()]));
    }

    @Override
    public void removeService(String string) throws WebServiceException {
        Server server = this.servers.get(string);
        if (server != null) {
            try {
                server.stop();
            }
            catch (Throwable throwable) {
                String string2 = "Web Service " + string + " can not be removed";
                if (this.log.isWarnEnabled()) {
                    this.log.warning((Object)string2, throwable);
                }
                throw new WebServiceException(string2, throwable);
            }
            this.servers.remove(string);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.startsWith(WEBSERVICE_FRACTAL_PREFIX)) {
            if (!KernelWebService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + KernelWebService.class.getName());
            }
            this.webServices.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.addAll((Collection)this.webServices.keySet());
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.startsWith(string)) {
            return this.webServices.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (this.webServices.containsKey(string)) {
            this.webServices.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

