/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.selector;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.ow2.petals.transport.platform.nio.selector.InputSocketChannelContext;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.transport.platform.nio.selector.NioServer;
import org.ow2.petals.transport.platform.nio.selector.OutputSocketChannelContext;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NioSelector.class)})
public class NioSelectorAgent
implements Runnable,
LifeCycleController,
NioSelector {
    private LoggingUtil log;
    private Selector selector;
    private Thread selectorAgentThread;
    private final Queue<PendingRegistration> registrationQueue = new LinkedBlockingQueue<PendingRegistration>();

    public String getFcState() {
        return null;
    }

    public final void register(int n, AbstractSelectableChannel abstractSelectableChannel, Object object) throws ClosedChannelException {
        this.registrationQueue.offer(new PendingRegistration(abstractSelectableChannel, n, object));
        this.selector.wakeup();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public final void run() {
        boolean bl = true;
        while (bl) {
            Object object;
            PendingRegistration pendingRegistration = null;
            while (!this.registrationQueue.isEmpty()) {
                try {
                    pendingRegistration = this.registrationQueue.poll();
                    pendingRegistration.socketChannel.register(this.selector, pendingRegistration.key, pendingRegistration.attachment);
                }
                catch (ClosedChannelException closedChannelException) {
                    object = pendingRegistration.socketChannel instanceof SocketChannel ? ((SocketChannel)pendingRegistration.socketChannel).socket().toString() : ((ServerSocketChannel)pendingRegistration.socketChannel).socket().toString();
                    this.log.error((Object)("Socket " + (String)object + " : " + closedChannelException.getMessage()), (Throwable)closedChannelException);
                }
            }
            try {
                if (this.selector.select() <= 0) continue;
                Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    iterator.remove();
                    if (!((SelectionKey)object).isValid()) continue;
                    if (((SelectionKey)object).isAcceptable()) {
                        this.accept((SelectionKey)object);
                        continue;
                    }
                    if (((SelectionKey)object).isReadable()) {
                        this.read((SelectionKey)object);
                        continue;
                    }
                    if (((SelectionKey)object).isWritable()) {
                        this.write((SelectionKey)object);
                        continue;
                    }
                    if (((SelectionKey)object).isConnectable()) {
                        this.endsConnection((SelectionKey)object);
                        continue;
                    }
                    this.log.warning((Object)"Unexpected event");
                }
            }
            catch (ClosedSelectorException closedSelectorException) {
                bl = false;
            }
            catch (IOException iOException) {
                this.log.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException {
        this.log = new LoggingUtil(Logger.getLogger("Petals.Transporter.NioTransportProtocol.NioSelectorAgent"));
        this.log.start();
        this.selectorAgentThread = new Thread((Runnable)this, "SelectorAgent Thread");
        this.selectorAgentThread.setDaemon(true);
        this.selector = Selector.open();
        this.selectorAgentThread.start();
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.start();
        this.selector.close();
        this.selectorAgentThread.interrupt();
        this.log.end();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void accept(SelectionKey selectionKey) throws IOException {
        this.log.start();
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        if (serverSocketChannel.isOpen()) {
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (socketChannel == null) throw new IOException("Accepted socket but not already created.");
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(true);
            socketChannel.configureBlocking(false);
            Object object = selectionKey.attachment();
            if (!(object instanceof NioServer)) throw new IOException("Unexpected key attachment on OP_ACCEPT: " + object.getClass().getName());
            ((NioServer)object).onConnectionIsAccepted(socketChannel, this.selector);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void endsConnection(SelectionKey selectionKey) throws IOException {
        this.log.start();
        try {
            Object object = selectionKey.attachment();
            if (!(object instanceof NioClient)) throw new IOException("Unexpected key attachment on OP_CONNECT: " + object.getClass().getName());
            NioClient nioClient = (NioClient)object;
            try {
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                if (!socketChannel.finishConnect()) throw new IOException("Unable to finish the socket connection");
                nioClient.onIsConnected(new OutputSocketChannelContext(socketChannel, nioClient));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Unable to connect: " + iOException.getMessage()));
                nioClient.onConnectionError(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.log.end();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.log.end();
    }

    private void read(SelectionKey selectionKey) throws IOException {
        this.log.start();
        Object object = selectionKey.attachment();
        if (object instanceof InputSocketChannelContext) {
            ((InputSocketChannelContext)object).read(selectionKey);
        } else if (object instanceof OutputSocketChannelContext) {
            ((OutputSocketChannelContext)object).onClose(selectionKey);
        } else {
            throw new IOException("Unexpected key attachment on OP_READ: " + object.getClass().getName());
        }
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void write(SelectionKey selectionKey) {
        this.log.start();
        Object object = selectionKey.attachment();
        if (object instanceof OutputSocketChannelContext) {
            ((OutputSocketChannelContext)object).write(selectionKey);
        } else {
            this.log.error((Object)("Unexpected key attachment on OP_WRITE: " + object.getClass().getName()));
        }
        this.log.end();
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private class PendingRegistration {
        protected AbstractSelectableChannel socketChannel;
        protected int key;
        protected Object attachment;

        public PendingRegistration(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
            this.socketChannel = abstractSelectableChannel;
            this.key = n;
            this.attachment = object;
        }
    }
}

