/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws.adapters;

import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.kernel.configuration.DomainConfiguration;
import org.ow2.petals.kernel.configuration.JndiConfiguration;
import org.ow2.petals.kernel.configuration.SubDomainConfiguration;
import org.ow2.petals.kernel.ws.api.to.ContainerInformation;
import org.ow2.petals.kernel.ws.api.to.DomainInformation;
import org.ow2.petals.kernel.ws.api.to.JmxServiceInformation;
import org.ow2.petals.kernel.ws.api.to.JndiInformation;
import org.ow2.petals.kernel.ws.api.to.RegistryServiceInformation;
import org.ow2.petals.kernel.ws.api.to.SubdomainInformation;
import org.ow2.petals.kernel.ws.api.to.TransportServiceInformation;
import org.ow2.petals.kernel.ws.api.to.WebServiceServiceInformation;

public class TopologyConfigurationToTopologyInformation {
    public static ContainerInformation containerConfigurationToContainerInformation(ContainerConfiguration containerConfiguration) throws PetalsException {
        ContainerInformation containerInformation = new ContainerInformation();
        if (containerConfiguration == null) {
            return null;
        }
        containerInformation.setName(containerConfiguration.getName());
        containerInformation.setDescription(containerConfiguration.getDescription());
        containerInformation.setHost(containerConfiguration.getHost());
        containerInformation.setUser(containerConfiguration.getUser());
        containerInformation.setPassword(containerConfiguration.getPassword());
        WebServiceServiceInformation webServiceServiceInformation = new WebServiceServiceInformation();
        webServiceServiceInformation.setPort(containerConfiguration.getWebservicePort());
        webServiceServiceInformation.setPrefix(containerConfiguration.getWebservicePrefix());
        containerInformation.setWebserviceService(webServiceServiceInformation);
        TransportServiceInformation transportServiceInformation = new TransportServiceInformation();
        transportServiceInformation.setTcpPort(containerConfiguration.getTCPPort());
        containerInformation.setTransportService(transportServiceInformation);
        RegistryServiceInformation registryServiceInformation = new RegistryServiceInformation();
        registryServiceInformation.setPort(containerConfiguration.getRegistryPort());
        containerInformation.setRegistryService(registryServiceInformation);
        JmxServiceInformation jmxServiceInformation = new JmxServiceInformation();
        jmxServiceInformation.setRmiPort(containerConfiguration.getJmxRMIConnectorPort());
        containerInformation.setJmxService(jmxServiceInformation);
        ContainerInformation.NodeType nodeType = null;
        switch (containerConfiguration.getRegistryMode()) {
            case MASTER: {
                nodeType = ContainerInformation.NodeType.MASTER;
                break;
            }
            case SLAVE: {
                nodeType = ContainerInformation.NodeType.SLAVE;
                break;
            }
            case PEER: {
                nodeType = ContainerInformation.NodeType.PEER;
                break;
            }
            case STANDALONE: {
                nodeType = ContainerInformation.NodeType.STANDALONE;
                break;
            }
            default: {
                throw new PetalsException("Unknown registry mode");
            }
        }
        containerInformation.setNodeType(nodeType);
        return containerInformation;
    }

    public static SubdomainInformation subDomainConfigurationToSubdomainInformation(SubDomainConfiguration subDomainConfiguration) throws PetalsException {
        SubdomainInformation.SubdomainMode subdomainMode;
        SubdomainInformation subdomainInformation = new SubdomainInformation();
        if (subDomainConfiguration == null) {
            return null;
        }
        subdomainInformation.setName(subDomainConfiguration.getName());
        subdomainInformation.setDescription(subDomainConfiguration.getDescription());
        subdomainInformation.setNetworkTimeSynchronized(subDomainConfiguration.isNetworkTimeSynchronized());
        switch (subDomainConfiguration.getMode()) {
            case MASTER_SLAVE: {
                subdomainMode = SubdomainInformation.SubdomainMode.MASTERSLAVE;
                break;
            }
            case FLOODING: {
                subdomainMode = SubdomainInformation.SubdomainMode.FLOODING;
                break;
            }
            case STANDALONE: {
                subdomainMode = SubdomainInformation.SubdomainMode.STANDALONE;
                break;
            }
            default: {
                throw new PetalsException("Unknown subdomain mode");
            }
        }
        subdomainInformation.setSubdomainMode(subdomainMode);
        return subdomainInformation;
    }

    public static DomainInformation domainConfigurationToDomainInformation(DomainConfiguration domainConfiguration) throws PetalsException {
        JndiInformation jndiInformation;
        DomainInformation domainInformation = new DomainInformation();
        if (domainConfiguration == null) {
            return null;
        }
        domainInformation.setName(domainConfiguration.getName());
        domainInformation.setDescription(domainConfiguration.getDescription());
        JndiConfiguration jndiConfiguration = domainConfiguration.getJndiConfiguration();
        if (jndiConfiguration != null) {
            jndiInformation = new JndiInformation();
            jndiInformation.setBatchSize(jndiConfiguration.getJndiBatchSize());
            jndiInformation.setPoolSize(jndiConfiguration.getJndiPoolSize());
            jndiInformation.setFactory(jndiConfiguration.getJndiFactory());
            jndiInformation.setProviderUrl(jndiConfiguration.getJndiProviderUrl().toString());
            jndiInformation.setSecurityPrincipal(jndiConfiguration.getJndiSecurityPrincipal());
            jndiInformation.setSecurityCredentials(jndiInformation.getSecurityCredentials());
            domainInformation.setJndiInformation(jndiInformation);
        }
        switch (domainConfiguration.getMode()) {
            case STANDALONE: {
                jndiInformation = DomainInformation.DomainMode.STANDALONE;
                break;
            }
            case STATIC: {
                jndiInformation = DomainInformation.DomainMode.STATIC;
                break;
            }
            case DYNAMIC: {
                jndiInformation = DomainInformation.DomainMode.DYNAMIC;
                break;
            }
            default: {
                throw new PetalsException("Unknown domain mode");
            }
        }
        domainInformation.setMode((DomainInformation.DomainMode)jndiInformation);
        return domainInformation;
    }
}

