/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.util;

import java.io.IOException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLVersionDetector
extends DefaultHandler {
    AbsItfDescription.WSDLVersionConstants version = null;

    public AbsItfDescription.WSDLVersionConstants getVersion() {
        return this.version;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals("description") && uri.equals("http://www.w3.org/ns/wsdl")) {
            this.version = AbsItfDescription.WSDLVersionConstants.WSDL20;
        }
        if (localName.equals("definitions") && uri.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.version = AbsItfDescription.WSDLVersionConstants.WSDL11;
        }
        if (this.version != null) {
            throw new SAXException("Cool! We found the WSDL version");
        }
        super.startElement(uri, localName, name, attributes);
    }

    public static AbsItfDescription.WSDLVersionConstants getVersion(InputSource input) throws WSDLException {
        WSDLVersionDetector versionDetector = new WSDLVersionDetector();
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(versionDetector);
            xmlReader.parse(input);
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            throw new WSDLException("Unable to get WSDL version.", e);
        }
        return versionDetector.getVersion();
    }

    public static AbsItfDescription.WSDLVersionConstants getVersion(Document doc) {
        String localPartWithoutPrefix = Util.getLocalPartWithoutPrefix(doc.getDocumentElement().getNodeName());
        AbsItfDescription.WSDLVersionConstants version = null;
        if (localPartWithoutPrefix.equals("description")) {
            version = AbsItfDescription.WSDLVersionConstants.WSDL20;
        }
        if (localPartWithoutPrefix.equals("definitions")) {
            version = AbsItfDescription.WSDLVersionConstants.WSDL11;
        }
        return version;
    }
}

