/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.Constants;
import org.ow2.petals.registry.api.config.DBConfiguration;
import org.ow2.petals.registry.api.exception.RegistryException;

public class PropertiesConfigurationLoader
implements ConfigurationLoader {
    public static final String REGISTRY_TRANSPORT_TIMEOUT = "registry.transport.timeout";
    public static final String REGISTRY_SYNCHRO_PERIOD = "registry.synchro.period";
    public static final String REGISTRY_MODE = "registry.mode";
    public static final String REGISTRY_DB_DIALECT = "registry.db.dialect";
    public static final String REGISTRY_DB_USER = "registry.db.user";
    public static final String REGISTRY_DB_PASSWORD = "registry.db.password";
    public static final String REGISTRY_DB_URL = "registry.db.url";
    public static final String REGISTRY_DB_DRIVER = "registry.db.driver";
    public static final String REGISTRY_DB_CACHING_ENABLED = "registry.db.caching.enabled";
    public static final String REGISTRY_DB_C3P0_ENABLED = "registry.db.c3p0.enabled";
    public static final String REGISTRY_TOPOLOGY_FILE = "registry.topology.file";
    public static final String REGISTRY_ROOTPATH = "registry.rootpath";
    public static final String REGISTRY_CLIENT_MANAGER_URL = "registry.client.manager.url";
    public static final String REGISTRY_CLIENT_MANAGER = "registry.client.manager";
    public static final String REGISTRY_MESSAGE_RECEIVER_URL = "registry.message.receiver.url";
    public static final String REGISTRY_MESSAGE_RECEIVER = "registry.message.receiver";
    public static final String REGISTRY_MESSAGE_SENDER = "registry.message.sender";
    public static final String REGISTRY_REPOSITORY = "registry.repository";
    public static final String REGISTRY_OUTGOING_MANAGER = "registry.outgoing.manager";
    public static final String REGISTRY_INCOMING_MANAGER = "registry.incoming.manager";
    private final Log log = LogFactory.getLog(PropertiesConfigurationLoader.class);

    @Override
    public Configuration loadLocal(InputStream is) throws RegistryException {
        if (is == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Stream is null, loading from the default resource");
            }
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/ow2/petals/registry/api/config/default_config.properties");
        }
        if (is == null) {
            throw new RegistryException("Can not load configuration from a null input stream");
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            String msg = "Can not load the resource file";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)msg, (Throwable)e);
            }
            throw new RegistryException(msg, e);
        }
        String name = props.getProperty("registry.name");
        Configuration configuration = new Configuration(name);
        configuration.setRegistryTransportTimeout(props.getProperty(REGISTRY_TRANSPORT_TIMEOUT));
        configuration.setRegistrySynchroPeriod(props.getProperty(REGISTRY_SYNCHRO_PERIOD));
        configuration.setIncomingManagerClassName(props.getProperty(REGISTRY_INCOMING_MANAGER, "org.ow2.petals.registry.core.manager.GenericIncomingManagerImpl"));
        configuration.setOutgoingManagerClassName(props.getProperty(REGISTRY_OUTGOING_MANAGER, "org.ow2.petals.registry.core.manager.GenericOutgoingManagerImpl"));
        configuration.setRepositoryClassName(props.getProperty(REGISTRY_REPOSITORY, "org.ow2.petals.registry.core.repository.jdbc.JDBCRepository"));
        configuration.setMessageReceiverClassName(props.getProperty(REGISTRY_MESSAGE_RECEIVER, "org.ow2.petals.registry.core.transport.cxf.CXFMessageReceiver"));
        configuration.setMessageReceiverURL(props.getProperty(REGISTRY_MESSAGE_RECEIVER_URL));
        configuration.setMessageSenderClassName(props.getProperty(REGISTRY_MESSAGE_SENDER, "org.ow2.petals.registry.core.transport.cxf.CXFMessageSender"));
        configuration.setClientManagerClassName(props.getProperty(REGISTRY_CLIENT_MANAGER));
        configuration.setClientManagerURL(props.getProperty(REGISTRY_CLIENT_MANAGER_URL));
        configuration.setRegistryMode(props.getProperty(REGISTRY_MODE, Constants.DEFAULT_REGISTRY_MODE));
        configuration.setRootPath(props.getProperty(REGISTRY_ROOTPATH));
        configuration.setTopologyFile(props.getProperty(REGISTRY_TOPOLOGY_FILE));
        DBConfiguration dbConfiguration = new DBConfiguration();
        dbConfiguration.setDriver(props.getProperty(REGISTRY_DB_DRIVER, "org.hsqldb.jdbcDriver"));
        dbConfiguration.setUrl(props.getProperty(REGISTRY_DB_URL, "jdbc:hsqldb:file:registry-database01"));
        dbConfiguration.setPassword(props.getProperty(REGISTRY_DB_PASSWORD, ""));
        dbConfiguration.setUsername(props.getProperty(REGISTRY_DB_USER, "SA"));
        dbConfiguration.setDialect(props.getProperty(REGISTRY_DB_DIALECT, "org.hibernate.dialect.HSQLDialect"));
        dbConfiguration.setCachingEnabled(props.getProperty(REGISTRY_DB_CACHING_ENABLED, "false").trim().equals("true"));
        dbConfiguration.setc3p0Enabled(props.getProperty(REGISTRY_DB_C3P0_ENABLED, "false").trim().equals("true"));
        configuration.setDbConfiguration(dbConfiguration);
        Iterator<Object> keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String elem = keys.next().toString();
            configuration.getExtensions().put(elem, props.getProperty(elem));
        }
        return configuration;
    }
}

