/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.ContextMap;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.arguments.ArgumentHelper;
import org.objectweb.fractal.adl.components.ComponentLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentComponentLoader
extends ComponentLoader {
    @Override
    protected Definition load(List<String> loaded, String name, Map<Object, Object> context) throws ADLException {
        int i;
        String n = name;
        Map<Object, Object> c = context;
        if (context != null && loaded.isEmpty()) {
            HashMap<String, Object> addedContext = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> entry : context.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                addedContext.put("__arg__" + entry.getKey(), entry.getValue());
            }
            context.putAll(addedContext);
        }
        if ((i = name.indexOf(40)) != -1) {
            if (!name.endsWith(")")) {
                throw new ADLException("Syntax error in definition name");
            }
            n = name.substring(0, i);
            c = ContextMap.instance();
            c.putAll(context);
            List<String> args = ArgumentHelper.splitNameList(name.substring(i + 1, name.length() - 1));
            if (args == null) {
                throw new ADLException("Syntax error in definition name.");
            }
            i = 0;
            boolean argByName = false;
            for (String arg : args) {
                String argval;
                String argname;
                int j = arg.indexOf("=>");
                int k = arg.indexOf("(");
                if (j != -1 && (k == -1 || j < k)) {
                    if (i != 0) {
                        throw new ADLException("Invalid definition name: cannot mix argument specified by name and argument specified by position.");
                    }
                    argByName = true;
                    argname = "__arg__" + arg.substring(0, j);
                    argval = ArgumentHelper.unquote(arg.substring(j + 2));
                    if (argval == null) {
                        throw new ADLException("Syntax error in definition name.");
                    }
                } else {
                    if (argByName) {
                        throw new ADLException("Invalid definition name: cannot mix argument specified by name and argument specified by position.");
                    }
                    argname = "__arg__" + i++;
                    argval = ArgumentHelper.unquote(arg);
                    if (argval == null) {
                        throw new ADLException("Syntax error in definition name.");
                    }
                }
                c.put(argname, argval);
            }
        }
        return super.load(loaded, n, c);
    }

    @Override
    protected List<String> parseDefinitions(String nameList, Node n) throws ADLException {
        List<String> l = ArgumentHelper.splitNameList(nameList);
        if (l == null) {
            throw new ADLException("Syntax error in definition name.", n);
        }
        return l;
    }

    @Override
    public boolean isShared(String definition) {
        return definition.indexOf(47) != -1 && definition.indexOf(40) == -1;
    }
}

