/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.arguments;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentHelper {
    protected static final String LPARENT = "(";
    protected static final String RPARENT = ")";
    protected static final String COMMA = ",";
    protected static final String LREF = "${";
    protected static final String RREF = "}";
    protected static final char QUOTE = '\'';
    protected static final char BACKSLASH = '\\';

    private ArgumentHelper() {
    }

    public static List<String> splitNameList(String nameList) {
        ArrayList<String> result = new ArrayList<String>();
        String currentName = "";
        int openedDelimiter = 0;
        for (String token : ArgumentHelper.tokenize(nameList)) {
            if (LPARENT.equals(token)) {
                ++openedDelimiter;
                currentName = currentName + token;
                continue;
            }
            if (RPARENT.equals(token)) {
                if (openedDelimiter == 0) {
                    return null;
                }
                --openedDelimiter;
                currentName = currentName + token;
                continue;
            }
            if (COMMA.equals(token)) {
                if (openedDelimiter == 0) {
                    result.add(currentName.trim());
                    currentName = "";
                    continue;
                }
                currentName = currentName + token;
                continue;
            }
            currentName = currentName + token;
        }
        result.add(currentName.trim());
        return result;
    }

    public static String[] splitNameRef(String line) {
        String prefix = null;
        String refName = null;
        String currentName = "";
        int openedDelimiter = 0;
        for (String token : ArgumentHelper.tokenize(line)) {
            if (refName == null && LREF.equals(token)) {
                if (prefix == null) {
                    prefix = currentName;
                    currentName = "";
                } else {
                    currentName = currentName + token;
                }
                ++openedDelimiter;
                continue;
            }
            if (refName == null && RREF.equals(token)) {
                if (openedDelimiter == 0) {
                    return null;
                }
                if (--openedDelimiter == 0) {
                    refName = currentName;
                    currentName = "";
                    continue;
                }
                currentName = currentName + token;
                continue;
            }
            currentName = currentName + token;
        }
        if (prefix == null) {
            return new String[]{currentName};
        }
        if (refName == null) {
            return null;
        }
        return new String[]{prefix, refName, currentName};
    }

    protected static LinkedList<String> tokenize(String line) {
        LinkedList<String> result = new LinkedList<String>();
        Matcher matcher = Pattern.compile("('([^'\\\\]|\\\\')*')|,|=| |\\(|\\)|(\\$\\{)|\\}").matcher(line);
        int i = 0;
        while (matcher.find()) {
            if (i != matcher.start()) {
                result.add(line.substring(i, matcher.start()));
            }
            result.add(matcher.group());
            i = matcher.end();
        }
        if (i != line.length()) {
            result.add(line.substring(i));
        }
        return result;
    }

    public static String unquote(String quoted) {
        StringBuilder sb = new StringBuilder();
        boolean inQuote = false;
        int length = quoted.length();
        for (int i = 0; i < length; ++i) {
            char c = quoted.charAt(i);
            if (c == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (inQuote && c == '\\') {
                if (i == length - 1) {
                    return null;
                }
                char n = quoted.charAt(i + 1);
                if (n == '\'') {
                    sb.append(n);
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (inQuote) {
            return null;
        }
        return sb.toString();
    }
}

