/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.bindings;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.bindings.Binding;
import org.objectweb.fractal.adl.bindings.BindingLoader;
import org.objectweb.fractal.adl.interfaces.IDLException;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeBindingLoader
extends BindingLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public IDLLoader interfaceCodeLoaderItf;

    @Override
    protected void checkBinding(Binding binding, Interface fromItf, Interface toItf, Map<Object, Object> context) throws ADLException {
        if (fromItf instanceof TypeInterface && toItf instanceof TypeInterface) {
            TypeInterface cItf = (TypeInterface)fromItf;
            TypeInterface sItf = (TypeInterface)toItf;
            if (binding.getFrom().startsWith("this.")) {
                if (!"server".equals(cItf.getRole())) {
                    throw new ADLException("Invalid binding: 'from' interface is not an internal client interface", binding);
                }
            } else if (!"client".equals(cItf.getRole())) {
                throw new ADLException("Invalid binding: 'from' interface is not a client interface", binding);
            }
            if (binding.getTo().startsWith("this.")) {
                if (!"client".equals(sItf.getRole())) {
                    throw new ADLException("Invalid binding: 'to' interface is not an internal server interface", binding);
                }
            } else if (!"server".equals(sItf.getRole())) {
                throw new ADLException("Invalid binding: 'to' interface is not a server interface", binding);
            }
            boolean cIsMandatory = true;
            if ("optional".equals(cItf.getContingency())) {
                cIsMandatory = false;
            }
            boolean sIsMandatory = true;
            if ("optional".equals(sItf.getContingency())) {
                sIsMandatory = false;
            }
            if (cIsMandatory && !sIsMandatory) {
                throw new ADLException("Invalid binding: binding from mandatory to optional interface", binding);
            }
            if (this.interfaceCodeLoaderItf != null) {
                try {
                    Object cClass = this.interfaceCodeLoaderItf.loadInterface(cItf.getSignature(), context);
                    Object sClass = this.interfaceCodeLoaderItf.loadInterface(sItf.getSignature(), context);
                    if (cClass instanceof Class && sClass instanceof Class && !((Class)cClass).isAssignableFrom((Class)sClass)) {
                        throw new ADLException("Invalid binding: incompatible signatures", binding);
                    }
                }
                catch (IDLException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected Interface getInterface(String name, Map<String, Interface> itfs) {
        Interface itf = super.getInterface(name, itfs);
        if (itf == null) {
            for (Map.Entry<String, Interface> entry : itfs.entrySet()) {
                TypeInterface typeItf;
                String cardinality;
                String n = entry.getKey();
                itf = itfs.get(n);
                if (!(itf instanceof TypeInterface) || !"collection".equals(cardinality = (typeItf = (TypeInterface)itf).getCardinality()) || !name.startsWith(n)) continue;
                return itf;
            }
            return null;
        }
        return itf;
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = (IDLLoader)o;
        } else {
            super.bindFc(s, o);
        }
    }

    @Override
    public String[] listFc() {
        String[] superList = super.listFc();
        String[] list = new String[superList.length + 1];
        list[0] = INTERFACE_LOADER_BINDING;
        System.arraycopy(superList, 0, list, 1, superList.length);
        return list;
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceCodeLoaderItf;
        }
        return super.lookupFc(s);
    }

    @Override
    public void unbindFc(String s) throws IllegalBindingException, NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceCodeLoaderItf = null;
        } else {
            super.unbindFc(s);
        }
    }
}

