/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.util;

import org.objectweb.fractal.adl.util.NoSuchComponentException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.util.Fractal;

public final class ContentControllerHelper {
    private ContentControllerHelper() {
    }

    public static Component getSubComponentByName(Component component, String subComponentName) throws NoSuchInterfaceException, NoSuchComponentException {
        Component[] subComponents;
        if (component == null) {
            throw new IllegalArgumentException("Component parameter is null");
        }
        if (subComponentName == null || subComponentName.length() == 0) {
            throw new IllegalArgumentException("Sub component name can't be null or empty");
        }
        ContentController contentController = Fractal.getContentController((Component)component);
        for (Component c : subComponents = contentController.getFcSubComponents()) {
            NameController nc = Fractal.getNameController((Component)c);
            if (!subComponentName.equals(nc.getFcName())) continue;
            return c;
        }
        throw new NoSuchComponentException("There is no subcomponent named '" + subComponentName + "'");
    }
}

