/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public final class FractalADLLogManager {
    public static final String DEFAULT_OUTPUT_DIR = "target/log";
    public static final String OUTPUT_FILE_NAME = "fractaladl.log.txt";
    public static final String OUTPUT_DIR_PROPERTY_NAME = "loggers.outdir";
    public static final String CONSOLE_LOGGER_SUFFIX = ".console";
    public static final String FILE_LOGGER_SUFFIX = ".file";
    public static final String LEVEL_SUFFIX = ".level";
    public static final String DEFAULT_CONSOLE_LEVEL_PROPERTY_NAME = "default.console.level";
    public static final String DEFAULT_FILE_LEVEL_PROPERTY_NAME = "default.file.level";
    public static final String ROOT_LOGGER_NAME = "fractaladl";
    public static final Level DEFAULT_VERBOSE_LEVEL;
    protected static final Map<String, Logger> LOGGER_MAP;
    public static final Logger STEP;
    protected static final Map<Logger, LoggerShelf> LOGGER_SHELF_MAP;

    private FractalADLLogManager() {
    }

    public static Logger getLogger(String name) {
        if (LOGGER_MAP.containsKey(name)) {
            return LOGGER_MAP.get(name);
        }
        Logger logger = new LoggerShelf(name).getLogger();
        LOGGER_MAP.put(name, logger);
        return logger;
    }

    public static Logger getLogger(String name, Level consoleLevel, Level fileLevel) {
        if (LOGGER_MAP.containsKey(name)) {
            return LOGGER_MAP.get(name);
        }
        Logger logger = new LoggerShelf(name, consoleLevel, fileLevel).getLogger();
        LOGGER_MAP.put(name, logger);
        return logger;
    }

    static {
        Level fileLevel;
        Level consoleLevel;
        DEFAULT_VERBOSE_LEVEL = Level.INFO;
        LOGGER_MAP = new HashMap<String, Logger>();
        String consoleLevelString = System.getProperty(DEFAULT_CONSOLE_LEVEL_PROPERTY_NAME, DEFAULT_VERBOSE_LEVEL.toString());
        try {
            consoleLevel = Level.parse(consoleLevelString);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: Invalid level value for [default.console.level]: \"" + consoleLevelString + "\". Defaulting to the parent's verbose level");
            consoleLevel = DEFAULT_VERBOSE_LEVEL;
        }
        String fileLevelString = System.getProperty(DEFAULT_FILE_LEVEL_PROPERTY_NAME, DEFAULT_VERBOSE_LEVEL.toString());
        try {
            fileLevel = Level.parse(fileLevelString);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Warning: Invalid level value for [default.file.level]: \"" + consoleLevelString + "\". Defaulting to the parent's verbose level");
            fileLevel = DEFAULT_VERBOSE_LEVEL;
        }
        LOGGER_SHELF_MAP = new IdentityHashMap<Logger, LoggerShelf>();
        LOGGER_MAP.put(ROOT_LOGGER_NAME, new LoggerShelf(ROOT_LOGGER_NAME, consoleLevel, fileLevel).getLogger());
        STEP = FractalADLLogManager.getLogger("step");
    }

    private static class LoggerShelf {
        private final Logger logger;
        private final Logger parentLogger;
        private final Handler consoleHandler;
        private final Handler fileHandler;

        public LoggerShelf(String name) {
            Level fileLevel;
            Level consoleLevel;
            String loggerName = name.equals(FractalADLLogManager.ROOT_LOGGER_NAME) ? name : "fractaladl." + name;
            this.logger = Logger.getLogger(loggerName);
            LOGGER_SHELF_MAP.put(this.logger, this);
            this.parentLogger = this.logger.getParent();
            LoggerShelf parentLoggerShelf = LOGGER_SHELF_MAP.get(this.parentLogger);
            String consoleLevelString = System.getProperty(name + FractalADLLogManager.CONSOLE_LOGGER_SUFFIX + FractalADLLogManager.LEVEL_SUFFIX, parentLoggerShelf.getConsoleHandler().getLevel().toString());
            try {
                consoleLevel = Level.parse(consoleLevelString);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Warning: Invalid level value for [" + name + FractalADLLogManager.CONSOLE_LOGGER_SUFFIX + FractalADLLogManager.LEVEL_SUFFIX + "]: \"" + consoleLevelString + "\". Defaulting to the parent's verbose level");
                consoleLevel = parentLoggerShelf.getConsoleHandler().getLevel();
            }
            String fileLevelString = System.getProperty(name + FractalADLLogManager.FILE_LOGGER_SUFFIX + FractalADLLogManager.LEVEL_SUFFIX, parentLoggerShelf.getFileHandler().getLevel().toString());
            try {
                fileLevel = Level.parse(fileLevelString);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Warning: Invalid level value for [" + name + FractalADLLogManager.FILE_LOGGER_SUFFIX + FractalADLLogManager.LEVEL_SUFFIX + "]: \"" + consoleLevelString + "\". Defaulting to the parent's verbose level");
                fileLevel = parentLoggerShelf.getFileHandler().getLevel();
            }
            this.logger.setUseParentHandlers(false);
            this.consoleHandler = new StdOutConsoleHandler();
            this.consoleHandler.setLevel(consoleLevel);
            this.logger.addHandler(this.consoleHandler);
            this.fileHandler = new SingletonFileHandler();
            this.fileHandler.setLevel(fileLevel);
            this.logger.addHandler(this.fileHandler);
            this.logger.setLevel(consoleLevel.intValue() < fileLevel.intValue() ? consoleLevel : fileLevel);
        }

        public LoggerShelf(String name, Level consoleLevel, Level fileLevel) {
            String loggerName = name.equals(FractalADLLogManager.ROOT_LOGGER_NAME) ? name : "fractaladl." + name;
            this.logger = Logger.getLogger(loggerName);
            LOGGER_SHELF_MAP.put(this.logger, this);
            this.parentLogger = this.logger.getParent();
            this.logger.setUseParentHandlers(false);
            this.consoleHandler = new StdOutConsoleHandler();
            this.consoleHandler.setLevel(consoleLevel);
            this.logger.addHandler(this.consoleHandler);
            this.fileHandler = new SingletonFileHandler();
            this.fileHandler.setLevel(fileLevel);
            this.logger.addHandler(this.fileHandler);
            this.logger.setLevel(consoleLevel.intValue() < fileLevel.intValue() ? consoleLevel : fileLevel);
        }

        public Logger getLogger() {
            return this.logger;
        }

        public Handler getConsoleHandler() {
            return this.consoleHandler;
        }

        public Handler getFileHandler() {
            return this.fileHandler;
        }
    }

    public static class SingletonFileHandler
    extends StreamHandler {
        private static PrintStream outputStream;
        protected static String outputDirectory;

        public SingletonFileHandler() {
            super(outputStream, new SimpleConsoleFormatter());
        }

        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }

        static {
            outputDirectory = null;
            if (outputDirectory == null) {
                outputDirectory = System.getProperty(FractalADLLogManager.OUTPUT_DIR_PROPERTY_NAME, FractalADLLogManager.DEFAULT_OUTPUT_DIR);
                new File(outputDirectory).mkdirs();
            }
            try {
                outputStream = new PrintStream(new File(outputDirectory, FractalADLLogManager.OUTPUT_FILE_NAME));
            }
            catch (FileNotFoundException e) {
                System.err.println("Log file '" + outputDirectory + File.pathSeparator + FractalADLLogManager.OUTPUT_FILE_NAME + "' not found");
                e.printStackTrace();
            }
        }
    }

    public static class StdOutConsoleHandler
    extends StreamHandler {
        StdOutConsoleHandler() {
            super(System.out, new SimpleConsoleFormatter());
        }

        public synchronized void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }

    private static class SimpleConsoleFormatter
    extends Formatter {
        private SimpleConsoleFormatter() {
        }

        public String format(LogRecord record) {
            String loggerName = record.getLoggerName();
            return "[" + loggerName.substring(loggerName.indexOf(46) + 1) + "] " + record.getMessage() + "\n";
        }
    }
}

