/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.xml;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.ADLNotFoundException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.Parser;
import org.objectweb.fractal.adl.ParserException;
import org.objectweb.fractal.adl.timestamp.Timestamp;
import org.objectweb.fractal.adl.util.ClassLoaderHelper;
import org.objectweb.fractal.adl.xml.XMLNodeFactory;
import org.objectweb.fractal.adl.xml.XMLParser;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLLoader
implements Loader,
BindingController {
    private boolean validate = true;
    private Parser parser;
    public static final String NODE_FACTORY_BINDING = "node-factory";
    public XMLNodeFactory nodeFactoryItf;

    public XMLLoader() {
    }

    public XMLLoader(boolean validate) {
        this.validate = validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        XMLLoader xMLLoader = this;
        synchronized (xMLLoader) {
            if (this.parser == null) {
                this.parser = new XMLParser(this.validate, this.nodeFactoryItf);
            }
        }
        String file = name.replace('.', '/') + ".fractal";
        ClassLoader cl = ClassLoaderHelper.getClassLoader(this, context);
        URL url = cl.getResource(file);
        if (url == null) {
            throw new ADLNotFoundException("Cannot find '" + file + "' in the classpath");
        }
        try {
            Definition d;
            this.nodeFactoryItf.setClassLoader(cl);
            try {
                d = (Definition)this.parser.parse(url.openStream(), file);
            }
            catch (IOException e) {
                throw new ADLNotFoundException("Cannot read '" + url + "'", e);
            }
            this.nodeFactoryItf.setClassLoader(ClassLoaderHelper.getClassLoader(this));
            if (d.getName() == null) {
                throw new ADLException("Definition name missing", d);
            }
            if (!d.getName().equals(name)) {
                throw new ADLException("Wrong definition name ('" + name + "' expected, instead of '" + d.getName() + "')", d);
            }
            Timestamp.setTimestamp((Node)d, url);
            return d;
        }
        catch (ParserException e) {
            throw new ADLException("Parse error while reading '" + url + "'.", null, (Exception)((Object)e));
        }
    }

    public void bindFc(String s, Object o) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (NODE_FACTORY_BINDING.equals(s)) {
            this.nodeFactoryItf = (XMLNodeFactory)o;
        }
    }

    public String[] listFc() {
        return new String[]{NODE_FACTORY_BINDING};
    }

    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (NODE_FACTORY_BINDING.equals(s)) {
            return this.nodeFactoryItf;
        }
        return null;
    }

    public void unbindFc(String s) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (NODE_FACTORY_BINDING.equals(s)) {
            this.nodeFactoryItf = null;
        }
    }
}

