/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.jmx.agent;

import java.lang.reflect.Method;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;

public class Introspector {
    private static final boolean VERBOSE = true;
    private static final boolean VERBOSE_DEBUG = false;
    public static String CURRENCY_TIME_LIMIT = "1";

    private Introspector() {
    }

    public static RequiredModelMBean createMBean(Object obj) throws JMException {
        try {
            return Introspector.createMBean(obj, obj.getClass());
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public static RequiredModelMBean createMBean(Object obj, Class assign) throws JMException, InvalidTargetObjectTypeException {
        Class<?> objClass = obj.getClass();
        if (!assign.isAssignableFrom(objClass)) {
            throw new InvalidTargetObjectTypeException(assign + " not a superclass or superinterface of " + objClass);
        }
        Method[] methods = assign.getMethods();
        Vector<ModelMBeanAttributeInfo> attributes = new Vector<ModelMBeanAttributeInfo>();
        Vector<ModelMBeanOperationInfo> operators = new Vector<ModelMBeanOperationInfo>();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().startsWith("get") || methods[i].getName().startsWith("set") || methods[i].getName().startsWith("is")) {
                try {
                    ModelMBeanAttributeInfo mmai = Introspector.doAttribute(methods, i);
                    if (mmai != null) {
                        attributes.add(mmai);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                ModelMBeanOperationInfo mmoi = Introspector.doOperation(methods, i);
                if (mmoi == null) continue;
                operators.add(mmoi);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ModelMBeanAttributeInfo[] attributeArray = new ModelMBeanAttributeInfo[attributes.size()];
        for (int i_ = 0; i_ < attributeArray.length; ++i_) {
            attributeArray[i_] = (ModelMBeanAttributeInfo)attributes.get(i_);
        }
        ModelMBeanOperationInfo[] operatorArray = new ModelMBeanOperationInfo[operators.size()];
        for (int i_ = 0; i_ < operatorArray.length; ++i_) {
            operatorArray[i_] = (ModelMBeanOperationInfo)operators.get(i_);
        }
        DescriptorSupport desc = new DescriptorSupport();
        desc.setField("name", objClass.getName());
        desc.setField("descriptorType", "MBean");
        ModelMBeanInfoSupport mminfo = new ModelMBeanInfoSupport(objClass.getName(), objClass.getName(), attributeArray, new ModelMBeanConstructorInfo[0], operatorArray, new ModelMBeanNotificationInfo[0], (Descriptor)desc);
        RequiredModelMBean model = new RequiredModelMBean(mminfo);
        model.setManagedResource(obj, "ObjectReference");
        return model;
    }

    private static ModelMBeanOperationInfo doOperation(Method[] methods, int i) throws JMException {
        DescriptorSupport desc = new DescriptorSupport();
        desc.setField("name", methods[i].getName());
        desc.setField("descriptorType", "operation");
        desc.setField("currencyTimeLimit", CURRENCY_TIME_LIMIT);
        if ((methods[i].getName().startsWith("get") || methods[i].getName().startsWith("is")) && methods[i].getParameterTypes().length == 0) {
            desc.setField("role", "getter");
        } else if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes().length == 1) {
            desc.setField("role", "setter");
        } else {
            desc.setField("role", "operation");
        }
        ModelMBeanOperationInfo mmoi = new ModelMBeanOperationInfo(methods[i].getName(), methods[i], (Descriptor)desc);
        return mmoi;
    }

    private static ModelMBeanAttributeInfo doAttribute(Method[] methods, int i) throws JMException {
        int i_;
        String name = null;
        Method getter = null;
        Method setter = null;
        String type = null;
        if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes().length == 0) {
            String setName = "s" + methods[i].getName().substring(1);
            name = methods[i].getName().substring(3);
            getter = methods[i];
            type = methods[i].getReturnType().getName();
            for (i_ = 0; i_ < methods.length; ++i_) {
                if (!methods[i_].getName().equals(setName)) continue;
                setter = methods[i_];
                break;
            }
        } else if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes().length == 1) {
            String getName = "g" + methods[i].getName().substring(1);
            name = methods[i].getName().substring(3);
            for (i_ = 0; i_ < methods.length; ++i_) {
                if (!methods[i_].getName().equals(getName)) continue;
                return null;
            }
            setter = methods[i];
            type = methods[i].getParameterTypes()[0].getName();
        } else if (methods[i].getName().startsWith("is") && methods[i].getParameterTypes() == null) {
            name = methods[i].getName().substring(2);
            getter = methods[i];
            type = Boolean.TYPE.getName();
        } else {
            return null;
        }
        DescriptorSupport desc = new DescriptorSupport();
        desc.setField("name", name);
        desc.setField("descriptorType", "attribute");
        desc.setField("displayName", name);
        desc.setField("currencyTimeLimit", CURRENCY_TIME_LIMIT);
        if (getter != null) {
            desc.setField("getMethod", getter.getName());
        }
        if (setter != null) {
            desc.setField("setMethod", setter.getName());
        }
        ModelMBeanAttributeInfo mmai = new ModelMBeanAttributeInfo(name, type, name, getter != null, setter != null, false, desc);
        return mmai;
    }
}

