/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.regulation;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.regulation.RegulationException;
import org.ow2.petals.regulation.generated.Regulation;
import org.xml.sax.SAXException;

public final class RegulationBuilder {
    public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String REGULATION_XSD = "petalsRegulation.xsd";
    private static Unmarshaller unmarshaller;
    private static RegulationException unmarshCreationEx;
    private static Marshaller marshaller;
    private static RegulationException marshallerCreationEx;

    private RegulationBuilder() {
    }

    public static Regulation createRegulation(String xmlFileName) throws RegulationException {
        return RegulationBuilder.createRegulation(new File(xmlFileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Regulation createRegulation(File xmlFile) throws RegulationException {
        if (unmarshaller == null) {
            throw unmarshCreationEx;
        }
        try {
            JAXBElement root;
            Unmarshaller unmarshaller = RegulationBuilder.unmarshaller;
            synchronized (unmarshaller) {
                root = RegulationBuilder.unmarshaller.unmarshal((Source)new StreamSource(xmlFile), Regulation.class);
            }
            return (Regulation)root.getValue();
        }
        catch (JAXBException e) {
            throw new RegulationException("Failed to build Regulation", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildXmlStringRegulation(Regulation regulationClass) throws RegulationException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = RegulationBuilder.marshaller;
            synchronized (marshaller) {
                RegulationBuilder.marshaller.marshal((Object)regulationClass, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new RegulationException("Failed to build XML binding from Regulation Java classes", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlFileRegulation(Regulation regulationClass, File regulationFile) throws RegulationException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            Marshaller marshaller = RegulationBuilder.marshaller;
            synchronized (marshaller) {
                RegulationBuilder.marshaller.marshal((Object)regulationClass, regulationFile);
            }
        }
        catch (JAXBException e) {
            throw new RegulationException("Failed to build XML binding from Regulation Java classes", (Exception)((Object)e));
        }
    }

    static {
        marshaller = null;
        marshallerCreationEx = null;
        InputStream schemaInputStream = RegulationBuilder.class.getResourceAsStream("/petalsRegulation.xsd");
        try {
            JAXBContext jaxbContext;
            SchemaFactory factory = SchemaFactory.newInstance(NAMESPACE_XSD);
            Source[] schemas = new StreamSource[]{new StreamSource(schemaInputStream)};
            Schema schema = factory.newSchema(schemas);
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Regulation.class});
                unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                unmarshCreationEx = new RegulationException("Failed to create the JAXB unmarshaller", (Exception)((Object)e));
            }
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Regulation.class});
                marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                marshallerCreationEx = new RegulationException("Failed to create the JAXB marshaller", (Exception)((Object)e));
            }
        }
        catch (SAXException e) {
            RegulationException schemaCreationEx = new RegulationException("Failed to parse resource 'petalsRegulation.xsd'", e);
            unmarshCreationEx = new RegulationException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new RegulationException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

