/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.descriptor.original;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.petals.jbi.descriptor.JBIDescriptorException;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class JBIDescriptorBuilder {
    public static final String XSD_JBI = "jbi.xsd";
    public static final String JBI_DESCRIPTOR_RESOURCE = "META-INF" + File.separator + "jbi.xml";
    private static Unmarshaller unmarshaller = null;
    private static Object unmarshallerSync;
    private static JBIDescriptorException unmarshallerCreationEx;
    private static Marshaller marshaller;
    private static Object marshallerSync;
    private static JBIDescriptorException marshallerCreationEx;

    private JBIDescriptorBuilder() {
    }

    public static void validateJBIDescriptor(InputStream jbiDescriptorStream) throws JBIDescriptorException {
        Validator validator = JBIDescriptorBuilder.getUnMarshaller().getSchema().newValidator();
        try {
            validator.validate(new StreamSource(jbiDescriptorStream));
        }
        catch (SAXException e) {
            throw new JBIDescriptorException("Failed to validate JBI descriptor against JBI schema", e);
        }
        catch (IOException e) {
            throw new JBIDescriptorException("Failed to validate JBI descriptor against JBI schema", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jbi buildJavaJBIDescriptor(InputStream jbiDescriptorStream) throws JBIDescriptorException {
        try {
            JAXBElement jbiBinding;
            Object object = unmarshallerSync;
            synchronized (object) {
                jbiBinding = JBIDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(jbiDescriptorStream), Jbi.class);
            }
            return (Jbi)jbiBinding.getValue();
        }
        catch (JAXBException e) {
            throw new JBIDescriptorException("Failed to build Java bindings from JBI descriptor XML document", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlJBIdescriptor(Jbi jbiDescriptorClass, Node jbiDescriptorNode) throws JBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbiDescriptorClass, jbiDescriptorNode);
            }
        }
        catch (JAXBException e) {
            throw new JBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJBIdescriptor(Jbi jbiDescriptorClass, OutputStream jbiDescrOutputStream) throws JBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbiDescriptorClass, jbiDescrOutputStream);
            }
        }
        catch (JAXBException e) {
            throw new JBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", e);
        }
    }

    private static Unmarshaller getUnMarshaller() throws JBIDescriptorException {
        if (unmarshallerCreationEx != null) {
            throw unmarshallerCreationEx;
        }
        return unmarshaller;
    }

    private static Marshaller getMarshaller() throws JBIDescriptorException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    static {
        unmarshallerCreationEx = null;
        marshaller = null;
        marshallerCreationEx = null;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            JAXBContext jaxbContext;
            URL schemaUrl = JBIDescriptorBuilder.class.getResource("/jbi.xsd");
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(schemaUrl.openStream())});
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Jbi.class});
                unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException e) {
                unmarshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB unmarshaller", e);
            }
            unmarshallerSync = new Object();
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Jbi.class});
                marshaller = jaxbContext.createMarshaller();
                marshaller.setSchema(schema);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (JAXBException e) {
                marshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB marshaller", e);
            }
            marshallerSync = new Object();
        }
        catch (IOException e) {
            JBIDescriptorException schemaCreationEx = new JBIDescriptorException("Failed to get resource 'jbi.xsd'from the current class-path", e);
            unmarshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
        catch (SAXException e) {
            JBIDescriptorException schemaCreationEx = new JBIDescriptorException("Failed to parse resource 'jbi.xsd'", e);
            unmarshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB unmarshaller", schemaCreationEx);
            marshallerCreationEx = new JBIDescriptorException("Failed to create the JAXB marshaller", schemaCreationEx);
        }
    }
}

