/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.ConfigurationLoaderFactory;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.RegistryException;

public class ContextFactory {
    private static final ContextFactory instance = new ContextFactory();

    public static ContextFactory getInstance() {
        return instance;
    }

    private ContextFactory() {
    }

    public final Context createContext(File registryConfigurationFile) throws RegistryException {
        if (registryConfigurationFile == null || !registryConfigurationFile.exists() || registryConfigurationFile.isDirectory()) {
            throw new RegistryException("Can not load from a null configuration file");
        }
        ConfigurationLoader loader = ConfigurationLoaderFactory.getLoader(registryConfigurationFile);
        if (loader == null) {
            throw new RegistryException("Can not get a configuration loader for the file " + registryConfigurationFile.getName());
        }
        Configuration config = null;
        try {
            config = loader.loadLocal(new FileInputStream(registryConfigurationFile));
        }
        catch (FileNotFoundException e) {
            throw new RegistryException(e);
        }
        return new Context(config);
    }

    public final Context createContext(Configuration configuration) throws RegistryException {
        return new Context(configuration);
    }
}

