/*
 * Decompiled with CFR 0.152.
 */
package spoon;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import spoon.Launcher;
import spoon.SpoonClassLoader;
import spoon.support.RuntimeProcessingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LtLauncher
extends Launcher {
    List<String> ltprocessors = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        new LtLauncher(args).run();
    }

    public LtLauncher(String[] args) throws JSAPException {
        super(args);
    }

    @Override
    protected JSAP defineArgs() throws JSAPException {
        JSAP jsap = super.defineArgs();
        FlaggedOption opt2 = new FlaggedOption("ltprocessors");
        opt2.setShortFlag('l');
        opt2.setLongFlag("ltprocessors");
        opt2.setHelp("List of load-time processors to use");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        jsap.registerParameter(opt2);
        opt2 = new FlaggedOption("sourcepath");
        opt2.setLongFlag("sourcepath");
        opt2.setHelp("Specify where to find input source files");
        opt2.setStringParser(JSAP.STRING_PARSER);
        opt2.setRequired(false);
        jsap.registerParameter(opt2);
        return jsap;
    }

    @Override
    public void addProcessor(String name) {
        super.addProcessor(name);
        this.ltprocessors.add(name);
    }

    protected List<String> getLtProcessorTypes() {
        if (this.getArguments().getString("ltprocessors") != null) {
            for (String processorName : this.getArguments().getString("ltprocessors").split(File.pathSeparator)) {
                this.ltprocessors.add(processorName);
            }
        }
        return this.ltprocessors;
    }

    @Override
    public void run() throws Exception {
        this.getFactory().getEnvironment().debugMessage("loading command-line arguments...");
        this.processArguments();
        this.getFactory().getEnvironment().debugMessage("start Processing...");
        long t = System.currentTimeMillis();
        this.build();
        this.getFactory().getEnvironment().debugMessage("model built in " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        this.process();
        this.getFactory().getEnvironment().debugMessage("model processed in " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        SpoonClassLoader ccl = new SpoonClassLoader();
        ccl.setFactory(this.getFactory());
        if (this.getArguments().getString("sourcepath") != null) {
            ccl.setSourcePath(new File(this.getArguments().getString("sourcepath")));
        }
        RuntimeProcessingManager pm = new RuntimeProcessingManager(this.getFactory());
        for (String s : this.getLtProcessorTypes()) {
            pm.addProcessor(s);
        }
        ccl.setProcessingManager(pm);
        this.getFactory().getEnvironment().debugMessage("running...");
        String progClass = this.getArguments().getString("class");
        String[] progArgs = this.getArguments().getStringArray("arguments");
        Class<?> clas = ccl.loadClass(progClass);
        Class[] mainArgType = new Class[]{new String[0].getClass()};
        Method main = clas.getMethod("main", mainArgType);
        Object[] argsArray = new Object[]{progArgs};
        main.invoke(null, argsArray);
    }
}

