/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.reflect.Field;
import java.util.Set;
import spoon.reflect.Factory;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldFactory
extends SubFactory {
    private static final long serialVersionUID = 1L;

    public FieldFactory(Factory factory) {
        super(factory);
    }

    public <T> CtField<T> create(CtSimpleType<?> target, Set<ModifierKind> modifiers, CtTypeReference<T> type, String name) {
        CtField<T> field = this.factory.Core().createField();
        field.setModifiers(modifiers);
        field.setType(type);
        field.setSimpleName(name);
        field.setParent(target);
        if (target != null) {
            target.getFields().add(field);
        }
        return field;
    }

    public <T> CtField<T> create(CtSimpleType<?> target, Set<ModifierKind> modifiers, CtTypeReference<T> type, String name, CtExpression<T> defaultExpression) {
        CtField<T> field = this.create(target, modifiers, type, name);
        field.setDefaultExpression(defaultExpression);
        return field;
    }

    public <T> CtField<T> create(CtType<?> target, CtField<T> source) {
        CtField<T> newField = this.factory.Core().clone(source);
        if (target != null) {
            target.getFields().add(newField);
        }
        newField.setParent(target);
        return newField;
    }

    public <T> CtFieldReference<T> createReference(CtField<T> field) {
        return this.createReference(this.factory.Type().createReference(field.getDeclaringType()), field.getType(), field.getSimpleName());
    }

    public <T> CtFieldReference<T> createReference(CtTypeReference<?> declaringType, CtTypeReference<T> type, String fieldName) {
        CtFieldReference<T> fieldRef = this.factory.Core().createFieldReference();
        fieldRef.setSimpleName(fieldName);
        fieldRef.setDeclaringType(declaringType);
        fieldRef.setType(type);
        return fieldRef;
    }

    public <T> CtFieldReference<T> createReference(Field field) {
        CtFieldReference<?> fieldRef = this.factory.Core().createFieldReference();
        fieldRef.setSimpleName(field.getName());
        fieldRef.setDeclaringType(this.factory.Type().createReference(field.getDeclaringClass()));
        fieldRef.setType(this.factory.Type().createReference(field.getType()));
        return fieldRef;
    }

    public <T> CtFieldReference<T> createReference(String signature) {
        CtFieldReference fieldRef = this.factory.Core().createFieldReference();
        String type = signature.substring(0, signature.indexOf(" "));
        String declaringType = signature.substring(signature.indexOf(" ") + 1, signature.indexOf("#"));
        String fieldName = signature.substring(signature.indexOf("#") + 1);
        fieldRef.setSimpleName(fieldName);
        fieldRef.setDeclaringType(this.factory.Type().createReference(declaringType));
        CtTypeReference typeRef = this.factory.Type().createReference(type);
        fieldRef.setType(typeRef);
        return fieldRef;
    }
}

