/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.Stack;
import spoon.processing.Environment;
import spoon.processing.Severity;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

public class ModelConsistencyChecker
extends CtScanner {
    boolean fixInconsistencies = false;
    Environment environment;
    Stack<CtElement> stack = new Stack();

    public ModelConsistencyChecker(Environment environment, boolean fixInconsistencies) {
        this.fixInconsistencies = fixInconsistencies;
        this.environment = environment;
    }

    public void enter(CtElement element) {
        if (!this.stack.isEmpty() && element.getParent() != this.stack.peek()) {
            if (this.fixInconsistencies) {
                element.setParent(this.stack.peek());
            } else {
                this.environment.report(null, Severity.WARNING, "inconsistent parent for " + element);
            }
        }
        this.stack.push(element);
    }

    protected void exit(CtElement e) {
        this.stack.pop();
    }
}

