/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.processing.AbstractProcessor;
import spoon.processing.FileGenerator;
import spoon.reflect.declaration.CompilationUnit;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.FragmentDrivenJavaPrettyPrinter;
import spoon.reflect.visitor.JavaPrettyPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOutputProcessor
extends AbstractProcessor<CtSimpleType<?>>
implements FileGenerator<CtSimpleType<?>> {
    File directory;
    List<File> printedFiles = new ArrayList<File>();
    boolean writePackageAnnotationFile = true;
    Map<String, Map<Integer, Integer>> lineNumberMappings = new HashMap<String, Map<Integer, Integer>>();

    public JavaOutputProcessor(File outputDirectory) {
        this.directory = outputDirectory;
    }

    @Override
    public List<File> getCreatedFiles() {
        return this.printedFiles;
    }

    @Override
    public File getOutputDirectory() {
        return this.directory;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJavaFile(CtSimpleType<?> element) {
        CompilationUnit cu = null;
        if (element.getPosition() != null) {
            cu = element.getPosition().getCompilationUnit();
        }
        if (cu != null && cu.getMainType() != element) {
            return;
        }
        ArrayList toBePrinted = new ArrayList();
        if (cu == null) {
            toBePrinted.add(element);
        } else {
            toBePrinted.addAll(cu.getDeclaredTypes());
        }
        JavaPrettyPrinter printer = null;
        if (this.getEnvironment().isUsingSourceCodeFragments()) {
            try {
                printer = new FragmentDrivenJavaPrettyPrinter(this.getEnvironment(), element.getPosition().getCompilationUnit());
            }
            catch (Exception e) {
                e.printStackTrace();
                printer = null;
            }
        }
        if (printer == null) {
            printer = new DefaultJavaPrettyPrinter(this.getEnvironment());
            printer.calculate(toBePrinted);
        }
        CtPackage pack = element.getPackage();
        PrintStream stream = null;
        if (this.directory == null) {
            throw new RuntimeException("You should set output directory before printing");
        }
        if (this.directory.isFile()) {
            throw new RuntimeException("Output must be a directory");
        }
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        File packageDir = pack.getQualifiedName().equals("unnamed package") ? new File(this.directory.getAbsolutePath()) : new File(this.directory.getAbsolutePath() + File.separatorChar + pack.getQualifiedName().replace('.', File.separatorChar));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            throw new RuntimeException("Error creating output directory");
        }
        if (this.writePackageAnnotationFile && element.getPackage().getAnnotations().size() > 0) {
            File packageAnnot = new File(packageDir.getAbsolutePath() + File.separatorChar + "package-info.java");
            if (!this.printedFiles.contains(packageAnnot)) {
                this.printedFiles.add(packageAnnot);
            }
            try {
                stream = new PrintStream(packageAnnot);
                stream.println(printer.getPackageDeclaration());
                stream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        try {
            File file = new File(packageDir.getAbsolutePath() + File.separatorChar + element.getSimpleName() + ".java");
            file.createNewFile();
            if (!this.printedFiles.contains(file)) {
                this.printedFiles.add(file);
            }
            stream = new PrintStream(file);
            stream.print(printer.getResult());
            for (CtSimpleType ctSimpleType : toBePrinted) {
                this.lineNumberMappings.put(ctSimpleType.getQualifiedName(), printer.getLineNumberMapping());
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Override
    public void process(CtSimpleType<?> type) {
        if (type.isTopLevel()) {
            this.createJavaFile(type);
        }
    }

    @Override
    public void setOutputDirectory(File directory) {
        this.directory = directory;
    }

    public Map<String, Map<Integer, Integer>> getLineNumberMappings() {
        return this.lineNumberMappings;
    }
}

