/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import spoon.processing.Builder;
import spoon.reflect.Factory;
import spoon.support.builder.CtFile;
import spoon.support.builder.CtFolder;
import spoon.support.builder.CtResource;
import spoon.support.builder.FileFactory;
import spoon.support.builder.JDTCompiler;
import spoon.support.builder.support.CtVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonBuildingManager
implements Builder {
    Factory factory;
    private boolean build = false;
    CtVirtualFolder sources = new CtVirtualFolder();
    CtVirtualFolder templates = new CtVirtualFolder();
    JDTCompiler compiler = null;
    public List<String> problems;

    public SpoonBuildingManager(Factory factory) {
        this.factory = factory;
    }

    @Override
    public void addInputSource(CtResource source) throws IOException {
        if (source.isFile()) {
            this.sources.addFile((CtFile)source);
        } else {
            this.sources.addFolder((CtFolder)source);
        }
    }

    @Override
    public void addInputSource(File source) throws IOException {
        if (FileFactory.isFile(source)) {
            this.sources.addFile(FileFactory.createFile(source));
        } else {
            this.sources.addFolder(FileFactory.createFolder(source));
        }
    }

    @Override
    public void addTemplateSource(CtResource source) throws IOException {
        if (source.isFile()) {
            this.templates.addFile((CtFile)source);
        } else {
            this.templates.addFolder((CtFolder)source);
        }
    }

    @Override
    public void addTemplateSource(File source) throws IOException {
        if (FileFactory.isFile(source)) {
            this.templates.addFile(FileFactory.createFile(source));
        } else {
            this.templates.addFolder(FileFactory.createFolder(source));
        }
    }

    @Override
    public boolean build() throws Exception {
        if (this.factory == null) {
            throw new Exception("Factory not initialized");
        }
        if (this.build) {
            throw new Exception("Model already built");
        }
        this.build = true;
        JDTCompiler.JAVA_COMPLIANCE = this.factory.getEnvironment().getComplianceLevel();
        this.factory.getEnvironment().debugMessage("compiling sources: " + this.sources.getAllJavaFiles());
        long t = System.currentTimeMillis();
        this.compiler = new JDTCompiler();
        this.initCompiler();
        boolean srcSuccess = this.compiler.compileSrc(this.factory, this.sources.getAllJavaFiles());
        if (!srcSuccess) {
            for (CategorizedProblem[] cps : this.compiler.probs) {
                for (int i = 0; i < cps.length; ++i) {
                    CategorizedProblem problem = cps[i];
                    if (problem == null) continue;
                    this.getProblems().add(problem.getMessage());
                }
            }
        }
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        this.factory.getEnvironment().debugMessage("compiling templates: " + this.templates.getAllJavaFiles());
        t = System.currentTimeMillis();
        boolean templateSuccess = this.compiler.compileTemplate(this.factory, this.templates.getAllJavaFiles());
        this.factory.Template().parseTypes();
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return srcSuccess && templateSuccess;
    }

    @Override
    public void initCompiler() {
    }

    @Override
    public List<String> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<String>();
        }
        return this.problems;
    }

    @Override
    public Set<File> getInputSources() {
        throw new RuntimeException("not implemented");
    }

    public CtVirtualFolder getSource() {
        return this.sources;
    }

    public CtVirtualFolder getTemplates() {
        return this.templates;
    }

    @Override
    public Set<File> getTemplateSources() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    public JDTCompiler getCompiler() {
        return this.compiler;
    }
}

