/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtSimpleType;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.util.RtHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtExecutableReferenceImpl<T>
extends CtReferenceImpl
implements CtExecutableReference<T> {
    private static final long serialVersionUID = 1L;
    boolean stat = false;
    List<CtTypeReference<?>> actualTypeArguments = new ArrayList();
    CtTypeReference<?> declaringType;
    List<CtTypeReference<?>> parametersTypes = new ArrayList();
    CtTypeReference<T> type;

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtExecutableReference(this);
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public boolean isConstructor() {
        return this.getSimpleName().equals("<init>");
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        A annotation = super.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Class<?> c = this.getDeclaringType().getActualClass();
        for (Method m : RtHelper.getAllMethods(c)) {
            if (!this.getSimpleName().equals(m.getName()) || this.getParameterTypes().size() != m.getParameterTypes().length) continue;
            int i = 0;
            for (Class<?> t : m.getParameterTypes()) {
                if (t != this.getParameterTypes().get(i).getActualClass()) break;
                ++i;
            }
            if (i != this.getParameterTypes().size()) continue;
            m.setAccessible(true);
            return m.getAnnotation(annotationType);
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annotations = super.getAnnotations();
        if (annotations != null) {
            return annotations;
        }
        Class<?> c = this.getDeclaringType().getActualClass();
        for (Method m : RtHelper.getAllMethods(c)) {
            if (!this.getSimpleName().equals(m.getName()) || this.getParameterTypes().size() != m.getParameterTypes().length) continue;
            int i = 0;
            for (Class<?> t : m.getParameterTypes()) {
                if (t != this.getParameterTypes().get(i).getActualClass()) break;
                ++i;
            }
            if (i != this.getParameterTypes().size()) continue;
            m.setAccessible(true);
            return m.getAnnotations();
        }
        return null;
    }

    @Override
    public CtExecutable<T> getDeclaration() {
        CtType typeDecl = (CtType)this.getDeclaringType().getDeclaration();
        if (typeDecl == null) {
            return null;
        }
        CtMethod<?> ret = typeDecl.getMethod(this.getSimpleName(), this.parametersTypes.toArray(new CtTypeReference[0]));
        if (ret == null && typeDecl instanceof CtClass && this.getSimpleName().equals("<init>")) {
            try {
                return ((CtClass)typeDecl).getConstructor(this.parametersTypes.toArray(new CtTypeReference[0]));
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public List<CtTypeReference<?>> getParameterTypes() {
        return this.parametersTypes;
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.type;
    }

    @Override
    public <S extends T> CtExecutableReference<S> getOverridingExecutable(CtTypeReference<?> subType) {
        if (subType == null || subType.equals(this.getDeclaringType())) {
            return null;
        }
        CtSimpleType<?> t = subType.getDeclaration();
        if (t == null) {
            return null;
        }
        if (!(t instanceof CtClass)) {
            return null;
        }
        CtClass c = (CtClass)t;
        for (CtMethod<?> m : c.getMethods()) {
            if (!m.getReference().isOverriding(this)) continue;
            return m.getReference();
        }
        return this.getOverridingExecutable(c.getSuperclass());
    }

    @Override
    public boolean isOverriding(CtExecutableReference<?> executable) {
        if (!this.getDeclaringType().isSubtypeOf(executable.getDeclaringType())) {
            return false;
        }
        if (!this.getSimpleName().equals(executable.getSimpleName())) {
            return false;
        }
        List<CtTypeReference<?>> l1 = this.getParameterTypes();
        List<CtTypeReference<?>> l2 = executable.getParameterTypes();
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i).isAssignableFrom(l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setActualTypeArguments(List<CtTypeReference<?>> actualTypeArguments) {
        this.actualTypeArguments = actualTypeArguments;
    }

    @Override
    public void setDeclaringType(CtTypeReference<?> declaringType) {
        this.declaringType = declaringType;
    }

    @Override
    public void setParameterTypes(List<CtTypeReference<?>> parameterTypes) {
        this.parametersTypes = parameterTypes;
    }

    @Override
    public void setType(CtTypeReference<T> type) {
        this.type = type;
    }

    @Override
    public Method getActualMethod() {
        for (Method m : this.getDeclaringType().getActualClass().getDeclaredMethods()) {
            if (!m.getName().equals(this.getSimpleName()) || m.getParameterTypes().length != this.getParameterTypes().size()) continue;
            boolean matches = true;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i] == this.getParameterTypes().get(i).getActualClass()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return m;
        }
        return null;
    }

    @Override
    public Constructor getActualConstructor() {
        for (Constructor<?> c : this.getDeclaringType().getActualClass().getDeclaredConstructors()) {
            if (c.getParameterTypes().length != this.getParameterTypes().size()) continue;
            boolean matches = true;
            for (int i = 0; i < c.getParameterTypes().length; ++i) {
                if (c.getParameterTypes()[i] == this.getParameterTypes().get(i).getActualClass()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public void setStatic(boolean b) {
        this.stat = b;
    }

    @Override
    public boolean isFinal() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            return e.hasModifier(ModifierKind.FINAL);
        }
        Method m = this.getActualMethod();
        if (m != null) {
            return Modifier.isFinal(m.getModifiers());
        }
        return false;
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            return e.getModifiers();
        }
        Method m = this.getActualMethod();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        Constructor c = this.getActualConstructor();
        if (c != null) {
            return RtHelper.getModifiers(c.getModifiers());
        }
        return new TreeSet<ModifierKind>();
    }

    @Override
    public CtExecutableReference<?> getOverridingExecutable() {
        CtTypeReference<?> st = this.getDeclaringType().getSuperclass();
        CtTypeReference<Object> objectType = this.getFactory().Type().createReference(Object.class);
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(st, objectType);
    }

    private CtExecutableReference<?> getOverloadedExecutable(CtTypeReference<?> t, CtTypeReference<Object> objectType) {
        if (t == null) {
            return null;
        }
        for (CtExecutableReference e : t.getDeclaredExecutables()) {
            if (!this.isOverriding(e)) continue;
            return e;
        }
        if (t.equals(objectType)) {
            return null;
        }
        CtTypeReference<?> st = t.getSuperclass();
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(t.getSuperclass(), objectType);
    }
}

