/*
 * Decompiled with CFR 0.152.
 */
package spoon.template;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.support.query.InvocationFilter;
import spoon.support.template.DefaultParameterMatcher;
import spoon.support.template.ParameterMatcher;
import spoon.support.template.Parameters;
import spoon.support.util.RtHelper;
import spoon.template.Parameter;
import spoon.template.Template;
import spoon.template.TemplateException;
import spoon.template.TemplateParameter;
import spoon.template.TemplateParameterList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateMatcher {
    private List<CtElement> finds = new ArrayList<CtElement>();
    private boolean found;
    private Map<Object, Object> matches = new HashMap<Object, Object>();
    private List<String> names;
    private CtClass<? extends Template> templateType;
    private List<CtTypeReference<?>> typeVariables;
    private List<CtFieldReference> varArgs;
    private List<CtInvocation<?>> variables;

    private static List<CtInvocation<?>> getMethods(CtClass<? extends Template> root) {
        CtExecutableReference<Object> methodRef = root.getFactory().Executable().createReference(root.getFactory().Type().createReference(TemplateParameter.class), root.getFactory().Type().createTypeParameterReference("T"), "S", new CtTypeReference[0]);
        List<CtInvocation<?>> meths = Query.getElements(root, new InvocationFilter(methodRef));
        return meths;
    }

    private static List<String> getTemplateNameParameters(CtClass<? extends Template> templateType) {
        ArrayList<String> ts = new ArrayList<String>();
        Collection<String> c = Parameters.getNames(templateType);
        ts.addAll(c);
        return ts;
    }

    private static List<CtTypeReference<?>> getTemplateTypeParameters(CtClass<? extends Template> templateType) {
        final ArrayList ts = new ArrayList();
        final Collection<String> c = Parameters.getNames(templateType);
        new CtScanner(){

            @Override
            public void visitCtTypeParameterReference(CtTypeParameterReference reference) {
                if (c.contains(reference.getSimpleName())) {
                    ts.add(reference);
                }
            }

            @Override
            public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
                if (c.contains(reference.getSimpleName())) {
                    ts.add(reference);
                }
            }
        }.scan(templateType);
        return ts;
    }

    private static List<CtFieldReference> getVarargs(CtClass<? extends Template> root, List<CtInvocation<?>> variables) {
        ArrayList<CtFieldReference> fields = new ArrayList<CtFieldReference>();
        for (CtFieldReference field : root.getReference().getAllFields()) {
            if (field.getType().getActualClass() != CtStatementList.class) continue;
            boolean alreadyAdded = false;
            for (CtInvocation<?> invocation : variables) {
                if (!(invocation instanceof CtInvocation)) continue;
                alreadyAdded |= ((CtFieldAccess)invocation.getTarget()).getVariable().getDeclaration().equals(field);
            }
            if (alreadyAdded) continue;
            fields.add(field);
        }
        return fields;
    }

    public TemplateMatcher(CtClass<? extends Template> templateType) {
        if (templateType == null) {
            throw new TemplateException("Template type is null. Use the template factory to access a template CtClass and check your template source path.");
        }
        this.variables = TemplateMatcher.getMethods(templateType);
        this.typeVariables = TemplateMatcher.getTemplateTypeParameters(templateType);
        this.names = TemplateMatcher.getTemplateNameParameters(templateType);
        this.varArgs = TemplateMatcher.getVarargs(templateType, this.variables);
        this.templateType = templateType;
    }

    private boolean addMatch(Object template, Object target) {
        Object inv = this.matches.get(template);
        Object o = this.matches.put(template, target);
        return null == inv || inv.equals(o);
    }

    private CtElement checkListStatements(List teList) {
        for (Object tem : teList) {
            if (this.variables.contains(tem) && tem instanceof CtInvocation) {
                CtInvocation listCand = (CtInvocation)tem;
                boolean ok = listCand.getFactory().Type().createReference(TemplateParameterList.class).isAssignableFrom(listCand.getTarget().getType());
                return ok ? listCand : null;
            }
            if (!(tem instanceof CtVariable)) continue;
            CtVariable var = (CtVariable)tem;
            String name = var.getSimpleName();
            for (CtFieldReference f : this.varArgs) {
                if (!f.getSimpleName().equals(name)) continue;
                return f.getDeclaration();
            }
        }
        return null;
    }

    public boolean find(CtElement targetRoot, final CtElement templateRoot) {
        this.found = false;
        new CtScanner(){

            public void scan(CtElement element) {
                if (TemplateMatcher.this.match(element, templateRoot)) {
                    TemplateMatcher.this.finds.add(element);
                    TemplateMatcher.this.found = true;
                }
                super.scan(element);
            }
        }.scan(targetRoot);
        return this.found;
    }

    private ParameterMatcher findParameterMatcher(CtElement declaration, String name) throws InstantiationException, IllegalAccessException {
        if (declaration == null) {
            return new DefaultParameterMatcher();
        }
        CtClass clazz = declaration.getParent(CtClass.class);
        if (clazz == null) {
            return new DefaultParameterMatcher();
        }
        Collection<CtFieldReference> fields = clazz.getReference().getAllFields();
        CtFieldReference param = null;
        for (CtFieldReference field : fields) {
            Parameter p = field.getAnnotation(Parameter.class);
            if (p == null) continue;
            String proxy = p.value();
            if (proxy != "" && name.contains(proxy)) {
                param = field;
                break;
            }
            if (!name.contains(field.getSimpleName()) || p == null) continue;
            param = field;
            break;
        }
        if (param == null) {
            throw new IllegalStateException("Parameter not defined " + name + "at " + declaration.getPosition());
        }
        return this.getParameterInstance(param);
    }

    private String getBindedParameter(String pname) {
        final String[] x = new String[]{pname};
        new CtScanner(){

            @Override
            public <T> void visitCtField(CtField<T> f) {
                Parameter p = f.getAnnotation(Parameter.class);
                if (p != null && p.value().equals(x[0])) {
                    x[0] = f.getSimpleName();
                    return;
                }
                super.visitCtField(f);
            }
        }.scan(this.templateType);
        return x[0];
    }

    public List<CtElement> getFinds() {
        return this.finds;
    }

    public Map<Object, Object> getMatches() {
        return this.matches;
    }

    private ParameterMatcher getParameterInstance(CtFieldReference param) throws InstantiationException, IllegalAccessException {
        Parameter anParam = param.getAnnotation(Parameter.class);
        if (anParam == null) {
            return new DefaultParameterMatcher();
        }
        Class<? extends ParameterMatcher> pm = anParam.match();
        ParameterMatcher instance = pm.newInstance();
        return instance;
    }

    private boolean helperMatch(Object target, Object template) {
        CtNamedElement named;
        CtReference tRef;
        boolean ok;
        if (target == null && template == null) {
            return true;
        }
        if (target == null || template == null) {
            return false;
        }
        if (this.variables.contains(template) || this.typeVariables.contains(template)) {
            boolean add = this.invokeCallBack(target, template);
            if (add) {
                return this.addMatch(template, target);
            }
            return false;
        }
        if (target.getClass() != template.getClass()) {
            return false;
        }
        if (template instanceof CtTypeReference && template.equals(this.templateType.getReference())) {
            return true;
        }
        if (template instanceof CtPackageReference && template.equals(this.templateType.getPackage())) {
            return true;
        }
        if (template instanceof CtReference && (ok = this.matchNames((tRef = (CtReference)template).getSimpleName(), ((CtReference)target).getSimpleName())) && !template.equals(target)) {
            boolean remove;
            boolean bl = remove = !this.invokeCallBack(target, template);
            if (remove) {
                this.matches.remove(tRef.getSimpleName());
                return false;
            }
            return true;
        }
        if (template instanceof CtNamedElement && (ok = this.matchNames((named = (CtNamedElement)template).getSimpleName(), ((CtNamedElement)target).getSimpleName())) && !template.equals(target)) {
            boolean remove;
            boolean bl = remove = !this.invokeCallBack(target, template);
            if (remove) {
                this.matches.remove(named.getSimpleName());
                return false;
            }
        }
        if (template instanceof Collection) {
            return this.matchCollections((Collection)target, (Collection)template);
        }
        if (target instanceof CtElement || target instanceof CtReference) {
            for (Field f : RtHelper.getAllFields(target.getClass())) {
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers()) || f.getName().equals("parent") || f.getName().equals("position") || f.getName().equals("docComment") || f.getName().equals("factory")) continue;
                try {
                    if (this.helperMatch(f.get(target), f.get(template))) continue;
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        if (target instanceof String) {
            return this.matchNames((String)template, (String)target);
        }
        return target.equals(template);
    }

    private boolean invokeCallBack(Object target, Object template) {
        try {
            if (template instanceof CtInvocation) {
                CtFieldAccess param = (CtFieldAccess)((CtInvocation)template).getTarget();
                ParameterMatcher instance = this.getParameterInstance(param.getVariable());
                return instance.match(this, (CtInvocation)template, (CtElement)target);
            }
            if (template instanceof CtReference) {
                CtReference ref = (CtReference)template;
                Parameter param = ref.getAnnotation(Parameter.class);
                ParameterMatcher instance = param == null ? new DefaultParameterMatcher() : param.match().newInstance();
                return instance.match(this, (CtReference)template, (CtReference)target);
            }
            if (template instanceof CtNamedElement) {
                CtNamedElement named = (CtNamedElement)template;
                ParameterMatcher instance = this.findParameterMatcher(named, named.getSimpleName());
                return instance.match(this, (CtElement)template, (CtElement)target);
            }
            throw new RuntimeException();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return true;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return true;
        }
    }

    private boolean isCurrentTemplate(Object object, CtElement inMulti) {
        if (object instanceof CtInvocation) {
            return object.equals(inMulti);
        }
        if (object instanceof CtParameter) {
            CtParameter param = (CtParameter)object;
            for (CtFieldReference varArg : this.varArgs) {
                if (!param.getSimpleName().equals(varArg.getSimpleName())) continue;
                return varArg.equals(inMulti);
            }
        }
        return false;
    }

    public boolean match(CtElement targetRoot, CtElement templateRoot) {
        return this.helperMatch(targetRoot, templateRoot);
    }

    private boolean matchCollections(Collection target, Collection template) {
        ArrayList teList = new ArrayList(template);
        ArrayList taList = new ArrayList(target);
        int numOfNonParamsinTeList = teList.size();
        CtElement inMulti = this.nextListStatement(teList, null);
        ArrayList<CtStatement> multi = new ArrayList<CtStatement>();
        if (null == inMulti) {
            if (teList.size() != taList.size()) {
                return false;
            }
            int te = 0;
            for (int ta = 0; te < teList.size() && ta < taList.size(); ++te, ++ta) {
                if (this.helperMatch(taList.get(ta), teList.get(te))) continue;
                return false;
            }
            return true;
        }
        int te = 0;
        for (int ta = 0; te < teList.size() && ta < taList.size(); ++te, ++ta) {
            CtStatementList tpl;
            if (this.isCurrentTemplate(teList.get(te), inMulti)) {
                --numOfNonParamsinTeList;
                if (te + 1 >= teList.size()) {
                    multi.addAll(taList.subList(te, taList.size()));
                    tpl = this.templateType.getFactory().Core().createStatementList();
                    tpl.setStatements(multi);
                    if (!this.invokeCallBack(tpl, inMulti)) {
                        return false;
                    }
                    boolean ret = this.addMatch(inMulti, multi);
                    return ret;
                }
                ++te;
                while (te < teList.size() && ta < taList.size() && !this.helperMatch(taList.get(ta), teList.get(te))) {
                    multi.add((CtStatement)((CtElement)taList.get(ta)));
                    ++ta;
                }
                tpl = this.templateType.getFactory().Core().createStatementList();
                tpl.setStatements(multi);
                if (!this.invokeCallBack(tpl, inMulti)) {
                    return false;
                }
                this.addMatch(inMulti, tpl);
                inMulti = this.nextListStatement(teList, inMulti);
                multi = new ArrayList();
                --numOfNonParamsinTeList;
                continue;
            }
            if (!this.helperMatch(taList.get(ta), teList.get(te))) {
                return false;
            }
            if (ta + 1 < taList.size() || inMulti == null) continue;
            tpl = this.templateType.getFactory().Core().createStatementList();
            tpl.setStatements(multi);
            if (!this.invokeCallBack(tpl, inMulti)) {
                return false;
            }
            this.addMatch(inMulti, tpl);
            inMulti = this.nextListStatement(teList, inMulti);
            multi = new ArrayList();
            --numOfNonParamsinTeList;
        }
        return true;
    }

    private boolean matchNames(String name, String tname) {
        try {
            for (String pname : this.names) {
                if (!name.contains(pname)) continue;
                String newName = name.replace(pname, "(.*)");
                Pattern p = Pattern.compile(newName);
                Matcher m = p.matcher(tname);
                if (!m.matches()) {
                    return false;
                }
                boolean ok = this.addMatch(pname, m.group(1));
                if (!ok) {
                    System.out.println("incongruent match");
                    return false;
                }
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return name.equals(tname);
    }

    private CtElement nextListStatement(List<?> teList, CtElement inMulti) {
        if (inMulti == null) {
            return this.checkListStatements(teList);
        }
        ArrayList teList2 = new ArrayList(teList);
        if (inMulti instanceof CtInvocation) {
            teList2.remove(inMulti);
        } else if (inMulti instanceof CtVariable) {
            CtVariable var = (CtVariable)inMulti;
            Iterator iter = teList2.iterator();
            while (iter.hasNext()) {
                CtVariable teVar = (CtVariable)iter.next();
                if (!teVar.getSimpleName().equals(var.getSimpleName())) continue;
                iter.remove();
            }
        }
        return this.checkListStatements(teList2);
    }
}

