/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.launcher.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.ow2.petals.launcher.configuration.Configuration;
import org.ow2.petals.launcher.configuration.ConfigurationException;
import org.ow2.petals.launcher.exception.UncompleteServerConfigurationException;
import org.ow2.petals.topology.TopologyBuilder;
import org.ow2.petals.topology.TopologyException;
import org.ow2.petals.topology.generated.Topology;

public class DefaultConfiguration
implements Configuration {
    public static final String DEFAULT_CONF_DIR = "conf";
    public static final String DEFAULT_INSTALL_DIR = "install";
    public static final String DEFAULT_INSTALLED_DIR = "installed";
    public static final String DEFAULT_LIB_DIR = "lib";
    public static final String DEFAULT_WORK_DIR = "work";
    public static final String DEFAULT_TOPOLOGY_FILE = "topology.xml";
    public static final String DEFAULT_SERVER_PROPERTIES_FILE = "server.properties";
    private final File home;
    private final Properties serverProperties;

    public DefaultConfiguration(String home) throws UncompleteServerConfigurationException {
        this.home = new File(home);
        this.serverProperties = new Properties();
        File serverPropertiesFile = new File(this.getConfDirectory(), DEFAULT_SERVER_PROPERTIES_FILE);
        if (serverPropertiesFile.exists() && serverPropertiesFile.isFile()) {
            try {
                this.serverProperties.load(new FileInputStream(serverPropertiesFile));
            }
            catch (IOException e) {
                throw new UncompleteServerConfigurationException(e);
            }
        }
    }

    @Override
    public File getConfDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_CONF_DIR);
    }

    @Override
    public File getHomeDirectory() {
        return this.home;
    }

    @Override
    public File getInstallDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_INSTALL_DIR);
    }

    @Override
    public File getInstalledDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_INSTALLED_DIR);
    }

    @Override
    public File getLibDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_LIB_DIR);
    }

    @Override
    public File getWorkDirectory() {
        return new File(this.getHomeDirectory(), DEFAULT_WORK_DIR);
    }

    @Override
    public int getStartupTimeoutSeconds() {
        return 20;
    }

    @Override
    public boolean isValid() throws ConfigurationException {
        for (File d : new File[]{this.getConfDirectory(), this.getHomeDirectory(), this.getInstallDirectory(), this.getInstalledDirectory()}) {
            if (d.isDirectory()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    @Override
    public Topology getTopology() throws UncompleteServerConfigurationException {
        String topologyUrl = (String)this.serverProperties.get("petals.topology.url");
        if (topologyUrl == null || topologyUrl.isEmpty()) {
            topologyUrl = new File(this.getConfDirectory(), DEFAULT_TOPOLOGY_FILE).getPath();
        }
        try {
            return TopologyBuilder.createTopology((String)topologyUrl);
        }
        catch (TopologyException e) {
            throw new UncompleteServerConfigurationException((Exception)((Object)e));
        }
    }

    @Override
    public String getLocalContainerId() throws UncompleteServerConfigurationException {
        String id = (String)this.serverProperties.get("petals.container.name");
        if (id == null || id.isEmpty()) {
            throw new UncompleteServerConfigurationException("Local container identifier is not defined.");
        }
        return id;
    }
}

