/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Factory;
import org.objectweb.fractal.adl.FactoryFactory;
import org.objectweb.fractal.adl.JavaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticJavaGenerator {
    public static final String COMMENT_PREFFIX = "#";
    public static final String CLASSNAME_SUFFIX = "JavaFactory";
    public static final String OUTPUT_PARAM_NAME = "o";
    public static final String INPUT_LIST_PARAM_NAME = "adls";
    protected Factory factory;
    protected Map<Object, Object> factoryContext;
    protected File outputDirectory;
    protected File adlsFile = null;
    protected List<String> adlsList = new ArrayList<String>();

    public StaticJavaGenerator(String ... args) throws ADLException, InvalidCommandLineException {
        this.init(this.parseArgsAsMap(args));
    }

    public StaticJavaGenerator(ClassLoader sourceClassLoader, String ... args) throws ADLException, InvalidCommandLineException {
        this.init(this.parseArgsAsMap(args));
        this.factoryContext.put("classloader", sourceClassLoader);
    }

    protected void init(Map<String, String> context) throws InvalidCommandLineException, ADLException {
        String backend;
        String adlsFileName;
        String outDirName = context.get(OUTPUT_PARAM_NAME);
        if (outDirName != null) {
            this.outputDirectory = new File(outDirName);
            if (!this.outputDirectory.exists()) {
                throw new InvalidCommandLineException("Invalid output directory \"" + this.outputDirectory + "\" does not exist.");
            }
            if (!this.outputDirectory.isDirectory()) {
                throw new InvalidCommandLineException("Invalid output directory \"" + this.outputDirectory + "\" is not a dirtectory.");
            }
        } else {
            this.outputDirectory = new File(".");
        }
        if ((adlsFileName = context.get(INPUT_LIST_PARAM_NAME)) != null) {
            this.adlsFile = new File(adlsFileName);
            if (!this.adlsFile.exists()) {
                throw new InvalidCommandLineException("Invalid ADL list \"" + this.adlsFile + "\" does not exist.");
            }
        }
        this.factoryContext = new HashMap<String, String>(context);
        String factoryDefinition = context.get("fractaladl.factory");
        if (factoryDefinition == null) {
            factoryDefinition = "org.objectweb.fractal.adl.BasicFactory";
        }
        if ((backend = context.get("fractaladl.backend")) == null) {
            backend = "org.objectweb.fractal.adl.StaticJavaBackend";
        }
        this.factory = FactoryFactory.getFactory(factoryDefinition, backend, new HashMap<Object, Object>(this.factoryContext));
    }

    public void generate() throws GenerationException {
        if (this.adlsFile != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(this.adlsFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith(COMMENT_PREFFIX) || line.trim().length() == 0) continue;
                    int index = line.indexOf(COMMENT_PREFFIX);
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    this.generate(line);
                }
                reader.close();
            }
            catch (IOException e) {
                throw new GenerationException("Can't read ADL list", e);
            }
        }
        for (String adl : this.adlsList) {
            this.generate(adl);
        }
    }

    protected void generate(String adlName) throws GenerationException {
        Object result;
        PrintWriter pw;
        File outputFile = this.getOutputFile(adlName);
        try {
            pw = new PrintWriter(new FileWriter(outputFile));
        }
        catch (IOException e) {
            throw new GenerationException("Can't write to file \"" + outputFile + "\".", e);
        }
        StringBuilder header = new StringBuilder();
        header.append("// THIS FILE HAS BEEN GENERATED BY THE FRACTAL ADL COMPILER.\n");
        header.append("// DO NOT EDIT\n\n");
        this.generateHeader(adlName, header);
        pw.println(header);
        HashMap<Object, Object> context = new HashMap<Object, Object>(this.factoryContext);
        context.put("printwriter", pw);
        try {
            result = this.factory.newComponent(adlName, context);
        }
        catch (ADLException e) {
            throw new GenerationException("An error occurs while compiling \"" + adlName + "\".", e);
        }
        StringBuilder footer = new StringBuilder();
        this.generateFooter(adlName, result, footer);
        pw.print(footer);
        pw.close();
    }

    protected void generateHeader(String adlName, StringBuilder header) {
        String className = this.getClassName(adlName);
        header.append("// instantiation code for ").append(adlName).append("\n");
        int index = className.lastIndexOf(".");
        if (index != -1) {
            header.append("package ").append(className.substring(0, index)).append(";\n\n");
            header.append("public class ").append(className.substring(index + 1));
        } else {
            header.append("public class ").append(className);
        }
        header.append(" implements ").append(JavaFactory.class.getName()).append("{\n\n");
        header.append("  public Object newComponent() throws Exception {\n");
    }

    protected void generateFooter(String adlName, Object result, StringBuilder footer) {
        footer.append("    return ").append(result).append(";\n");
        footer.append("  }\n");
        footer.append("}\n");
    }

    protected String getClassName(String adlName) {
        int index = adlName.indexOf(40);
        if (index != -1) {
            adlName = adlName.substring(0, index);
        }
        return adlName + CLASSNAME_SUFFIX;
    }

    protected File getOutputFile(String adlName) {
        File outputFile = new File(this.outputDirectory, this.getClassName(adlName).replace('.', File.separatorChar) + ".java");
        outputFile.getParentFile().mkdirs();
        return outputFile;
    }

    public static void main(String ... args) {
        try {
            new StaticJavaGenerator(args).generate();
        }
        catch (ADLException e) {
            System.err.println("An error occurs while instantiating the FractalADL factory.");
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvalidCommandLineException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (GenerationException e) {
            Throwable t = e;
            do {
                System.err.println(t.getLocalizedMessage());
            } while ((t = t.getCause()) != null);
            System.exit(1);
        }
    }

    protected Map<String, String> parseArgsAsMap(String[] args) throws InvalidCommandLineException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String currentArg : args) {
            if (currentArg.startsWith("-")) {
                int index = currentArg.indexOf("=");
                if (index != -1) {
                    String paramName = currentArg.substring("-".length(), index);
                    String paramValue = currentArg.substring(index + "=".length());
                    result.put(paramName, paramValue);
                    continue;
                }
                StaticJavaGenerator.parseError();
                continue;
            }
            this.adlsList.add(currentArg);
        }
        return result;
    }

    protected static void parseError() throws InvalidCommandLineException {
        StringBuilder sb = new StringBuilder();
        sb.append("StaticJavaGenerator: generate Java source code that instantiates ADL definitions\n");
        sb.append("Usage: StaticJavaGenerator [DEFINITION...]\n\n");
        sb.append("  where DEFINITION is a list of ADL definition to be generated.\n\n");
        sb.append("Valid options:\n");
        sb.append("  -o=PATH     : Specify the directory into which generated files are placed\n");
        sb.append("  -adls=PATH  : Specify a file that contains a list of ADL definition to compile.\n");
        sb.append("                one definition per line");
        throw new InvalidCommandLineException(sb.toString());
    }

    public static class GenerationException
    extends Exception {
        GenerationException() {
        }

        GenerationException(String message, Throwable cause) {
            super(message, cause);
        }

        GenerationException(Throwable cause) {
            super(cause);
        }

        GenerationException(String message) {
            super(message);
        }
    }

    public static class InvalidCommandLineException
    extends Exception {
        InvalidCommandLineException(String message) {
            super(message);
        }
    }
}

