/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.implementations;

import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.components.PrimitiveCompiler;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationBuilder;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.implementations.TemplateControllerContainer;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;
import org.objectweb.fractal.task.deployment.lib.AbstractInstanceProviderTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationCompiler
implements BindingController,
PrimitiveCompiler {
    public static final String BUILDER_BINDING = "builder";
    public ImplementationBuilder builder;

    public String[] listFc() {
        return new String[]{BUILDER_BINDING};
    }

    public Object lookupFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            return this.builder;
        }
        return null;
    }

    public void bindFc(String itf, Object value) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = (ImplementationBuilder)value;
        }
    }

    public void unbindFc(String itf) {
        if (itf.equals(BUILDER_BINDING)) {
            this.builder = null;
        }
    }

    @Override
    public void compile(List<ComponentContainer> path, ComponentContainer container, TaskMap tasks, Map<Object, Object> context) throws ADLException {
        TemplateControllerContainer tcc;
        ControllerContainer cc;
        ImplementationContainer ic;
        Implementation i;
        boolean template = context != null && "true".equals(context.get("template"));
        String implementation = null;
        if (container instanceof ImplementationContainer && (i = (ic = (ImplementationContainer)((Object)container)).getImplementation()) != null) {
            implementation = i.getClassName();
        }
        String controller = null;
        if (container instanceof ControllerContainer && (cc = (ControllerContainer)((Object)container)).getController() != null) {
            controller = cc.getController().getDescriptor();
        }
        String templateController = null;
        if (container instanceof TemplateControllerContainer && (tcc = (TemplateControllerContainer)((Object)container)).getTemplateController() != null) {
            templateController = tcc.getTemplateController().getDescriptor();
            template = true;
        }
        String name = null;
        if (container instanceof Definition) {
            name = ((Definition)((Object)container)).getName();
        } else if (container instanceof Component) {
            name = ((Component)container).getName();
        }
        String definition = null;
        definition = container instanceof Definition ? name : (String)container.astGetDecoration("definition");
        boolean attrs = false;
        if (container instanceof AttributesContainer) {
            attrs = ((AttributesContainer)((Object)container)).getAttributes() != null;
        }
        Component[] comps = container.getComponents();
        try {
            tasks.getTask("create", (Object)container);
        }
        catch (NoSuchElementException e) {
            AbstractInstanceProviderTask createTask;
            if (comps.length > 0 || implementation == null) {
                if (implementation != null) {
                    throw new ADLException("Implementation must be empty", container);
                }
                if (controller == null) {
                    controller = "composite";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricCompositeTemplate" : "compositeTemplate";
                    }
                    createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, null}, context);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, null, context);
                }
            } else {
                if (controller == null) {
                    controller = "primitive";
                }
                if (template) {
                    if (templateController == null) {
                        templateController = attrs ? "parametricPrimitiveTemplate" : "primitiveTemplate";
                    }
                    createTask = this.newCreateTask(path, container, name, definition, templateController, new Object[]{controller, implementation}, context);
                } else {
                    createTask = this.newCreateTask(path, container, name, definition, controller, implementation, context);
                }
            }
            tasks.addTask("create", (Object)container, (Task)createTask);
            TaskMap.TaskHole typeTaskHole = tasks.getTaskHole("type", (Object)container);
            createTask.setFactoryProviderTask(typeTaskHole);
            createTask.addDependency(typeTaskHole, Task.PREVIOUS_TASK_ROLE, context);
        }
    }

    public AbstractInstanceProviderTask newCreateTask(List<ComponentContainer> path, ComponentContainer container, String name, String definition, Object controller, Object implementation, Map<Object, Object> context) {
        return new CreateTask(this.builder, name, definition, controller, implementation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CreateTask
    extends AbstractInstanceProviderTask {
        ImplementationBuilder builder;
        String name;
        String definition;
        Object controllerDesc;
        Object contentDesc;

        public CreateTask(ImplementationBuilder builder, String name, String definition, Object controllerDesc, Object contentDesc) {
            this.builder = builder;
            this.name = name;
            this.definition = definition;
            this.controllerDesc = controllerDesc;
            this.contentDesc = contentDesc;
        }

        public void execute(Map<Object, Object> context) throws Exception {
            if (this.getInstance() != null) {
                return;
            }
            Object type = this.getFactoryProviderTask().getFactory();
            Object result = this.builder.createComponent(type, this.name, this.definition, this.controllerDesc, this.contentDesc, context);
            this.setInstance(result);
        }

        public String toString() {
            return "T" + System.identityHashCode((Object)this) + "[CreateTask(" + this.name + "," + this.controllerDesc + "," + this.contentDesc + ")]";
        }
    }
}

