/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.implementations;

import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.Loader;
import org.objectweb.fractal.adl.attributes.Attributes;
import org.objectweb.fractal.adl.attributes.AttributesContainer;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.implementations.Controller;
import org.objectweb.fractal.adl.implementations.ControllerContainer;
import org.objectweb.fractal.adl.implementations.Implementation;
import org.objectweb.fractal.adl.implementations.ImplementationCodeLoader;
import org.objectweb.fractal.adl.implementations.ImplementationContainer;
import org.objectweb.fractal.adl.implementations.ImplementationException;
import org.objectweb.fractal.adl.interfaces.IDLLoader;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;
import org.objectweb.fractal.adl.types.TypeInterface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationLoader
extends AbstractLoader {
    public static final String INTERFACE_LOADER_BINDING = "interface-loader";
    public static final String IMPLEMENTATION_LOADER_BINDING = "implementation-code-loader";
    public IDLLoader interfaceLoaderItf;
    public ImplementationCodeLoader implementationCodeLoaderItf;

    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d, context);
        return d;
    }

    protected void checkNode(Object node, Map<Object, Object> context) throws ADLException {
        if (node instanceof ImplementationContainer) {
            this.checkImplementationContainer((ImplementationContainer)node, context);
        }
        if (node instanceof ControllerContainer) {
            this.checkControllerContainer((ControllerContainer)node);
        }
        if (node instanceof ComponentContainer) {
            for (Component comp : ((ComponentContainer)node).getComponents()) {
                this.checkNode(comp, context);
            }
        }
    }

    protected void checkImplementationContainer(ImplementationContainer container, Map<Object, Object> context) throws ADLException {
        Object d;
        Attributes attrs;
        Object c;
        Implementation impl = container.getImplementation();
        if (impl == null) {
            return;
        }
        String className = impl.getClassName();
        if (className == null) {
            throw new ADLException("Implementation class name missing", impl);
        }
        try {
            c = this.implementationCodeLoaderItf.loadImplementation(className, null, context);
        }
        catch (ImplementationException e) {
            throw new ADLException("Invalid implementation", impl, e);
        }
        impl.astSetDecoration("code", c);
        if (!(c instanceof Class)) {
            return;
        }
        Class implemClass = (Class)c;
        if (container instanceof InterfaceContainer) {
            for (Interface itf : ((InterfaceContainer)((Object)container)).getInterfaces()) {
                Object d2;
                TypeInterface tItf;
                if (!(itf instanceof TypeInterface) || !(tItf = (TypeInterface)itf).getRole().equals("server") || !((d2 = this.interfaceLoaderItf.loadInterface(tItf.getSignature(), context)) instanceof Class) || ((Class)d2).isAssignableFrom(implemClass)) continue;
                throw new ADLException("The implementation class does not implement all the server interfaces of the component", impl);
            }
        }
        if (container instanceof AttributesContainer && (attrs = ((AttributesContainer)((Object)container)).getAttributes()) != null && (d = this.interfaceLoaderItf.loadInterface(attrs.getSignature(), context)) instanceof Class && !((Class)d).isAssignableFrom(implemClass)) {
            throw new ADLException("The implementation class does not implement all the attribute controller interface of the component", impl);
        }
    }

    protected void checkControllerContainer(ControllerContainer container) throws ADLException {
        Controller ctrl = container.getController();
        if (ctrl != null && ctrl.getDescriptor() == null) {
            throw new ADLException("Controller descriptor missing", ctrl);
        }
    }

    @Override
    public void bindFc(String s, Object o) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("client-loader".equals(s)) {
            this.clientLoader = (Loader)o;
        } else if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = (IDLLoader)o;
        } else if (IMPLEMENTATION_LOADER_BINDING.equals(s)) {
            this.implementationCodeLoaderItf = (ImplementationCodeLoader)o;
        } else {
            throw new NoSuchInterfaceException("There is no interface named '" + s + "'");
        }
    }

    @Override
    public String[] listFc() {
        return new String[]{"client-loader", INTERFACE_LOADER_BINDING, IMPLEMENTATION_LOADER_BINDING};
    }

    @Override
    public Object lookupFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("client-loader".equals(s)) {
            return this.clientLoader;
        }
        if (INTERFACE_LOADER_BINDING.equals(s)) {
            return this.interfaceLoaderItf;
        }
        if (IMPLEMENTATION_LOADER_BINDING.equals(s)) {
            return this.implementationCodeLoaderItf;
        }
        throw new NoSuchInterfaceException("There is no interface named '" + s + "'");
    }

    @Override
    public void unbindFc(String s) throws NoSuchInterfaceException {
        if (s == null) {
            throw new IllegalArgumentException("Interface name can't be null");
        }
        if ("client-loader".equals(s)) {
            this.clientLoader = null;
        } else if (INTERFACE_LOADER_BINDING.equals(s)) {
            this.interfaceLoaderItf = null;
        } else if (IMPLEMENTATION_LOADER_BINDING.equals(s)) {
            this.implementationCodeLoaderItf = null;
        } else {
            throw new NoSuchInterfaceException("There is no interface named '" + s + "'");
        }
    }
}

