/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl.interfaces;

import java.util.HashSet;
import java.util.Map;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.AbstractLoader;
import org.objectweb.fractal.adl.Definition;
import org.objectweb.fractal.adl.components.Component;
import org.objectweb.fractal.adl.components.ComponentContainer;
import org.objectweb.fractal.adl.interfaces.Interface;
import org.objectweb.fractal.adl.interfaces.InterfaceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceLoader
extends AbstractLoader {
    @Override
    public Definition load(String name, Map<Object, Object> context) throws ADLException {
        Definition d = this.clientLoader.load(name, context);
        this.checkNode(d);
        return d;
    }

    private void checkNode(Object node) throws ADLException {
        if (node instanceof InterfaceContainer) {
            this.checkInterfaceContainer((InterfaceContainer)node);
        }
        if (node instanceof ComponentContainer) {
            Component[] comps;
            for (Component element : comps = ((ComponentContainer)node).getComponents()) {
                this.checkNode(element);
            }
        }
    }

    private void checkInterfaceContainer(InterfaceContainer container) throws ADLException {
        Interface[] itfs;
        HashSet<String> names = new HashSet<String>();
        for (Interface itf : itfs = container.getInterfaces()) {
            if (itf.getName() == null) {
                throw new ADLException("Interface name missing", itf);
            }
            if (names.contains(itf.getName())) {
                throw new ADLException("Duplicate interface name '" + itf.getName() + "'", itf);
            }
            names.add(itf.getName());
        }
    }
}

