/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.adl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.fractal.adl.AbstractNode;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeClassLoader;
import org.objectweb.fractal.adl.NodeFactory;

public class NodeFactoryImpl
implements NodeFactory {
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    SimpleNodeClassLoader nodeClassLoader;

    public Node newNode(String nodeType, String ... interfaces) throws ClassNotFoundException {
        if (this.nodeClassLoader == null) {
            this.nodeClassLoader = new SimpleNodeClassLoader(this.classLoader);
        }
        Class<? extends Node> c = this.nodeClassLoader.getNodeClass(interfaces);
        try {
            return c.getConstructor(String.class).newInstance(nodeType);
        }
        catch (Exception e) {
            throw new Error("An error occurs while instantiating Node", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        if (loader != this.classLoader) {
            this.classLoader = loader;
            this.nodeClassLoader = null;
        }
    }

    static final class NodeClassId {
        final String[] itfs;

        NodeClassId(String[] itfs) {
            this.itfs = itfs;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.itfs);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof String[]) {
                return Arrays.equals(this.itfs, (String[])obj);
            }
            if (obj instanceof NodeClassId) {
                return Arrays.equals(this.itfs, ((NodeClassId)obj).itfs);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SimpleNodeClassLoader
    extends NodeClassLoader {
        final Map<NodeClassId, Class<? extends Node>> classes = new HashMap<NodeClassId, Class<? extends Node>>();

        SimpleNodeClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class<? extends Node> getNodeClass(String ... itfs) throws ClassNotFoundException {
            Class<Node> c = this.classes.get(itfs);
            if (c != null) {
                String name = "org.objectweb.fractal.adl.Node" + this.classes.size();
                ClassWriter cw = this.generateClass(name, name, Type.getInternalName(AbstractNode.class), itfs);
                c = this.defineClass(name, cw.toByteArray());
                this.classes.put(new NodeClassId(itfs), c);
            }
            return c;
        }
    }
}

