/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.util.monolog;

import java.util.Properties;
import org.objectweb.util.monolog.TestHelper;
import org.objectweb.util.monolog.TestSuite;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Handler;
import org.objectweb.util.monolog.api.MonologFactory;
import org.objectweb.util.monolog.api.TopicalLogger;

public class TestConfigurability
extends TestHelper {
    String mode = null;
    String configFileName = null;
    String useClassPath = null;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestConfigurability;
    static /* synthetic */ Class class$org$objectweb$util$monolog$TestLogger;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Syntax error !");
            System.out.println("java TestConfigurability <logger factory class name> <mode> [<config file name> [ true | false ]]");
            System.exit(1);
        }
        int size = args.length;
        String[] params = new String[size];
        String[] methods = new String[size];
        params[0] = args[1];
        methods[0] = "setConfigMode";
        if (args.length > 2) {
            params[1] = args[2];
            methods[1] = "setConfigFile";
        }
        if (args.length > 3) {
            params[2] = args[3];
            methods[2] = "setUseClassPath";
        }
        params[params.length - 1] = "";
        methods[methods.length - 1] = "init";
        TestHelper.run(class$org$objectweb$util$monolog$TestConfigurability == null ? (class$org$objectweb$util$monolog$TestConfigurability = TestConfigurability.class$("org.objectweb.util.monolog.TestConfigurability")) : class$org$objectweb$util$monolog$TestConfigurability, methods, params, args[0]);
    }

    public static TestSuite getTestSuite(String lfcn, String mode, String configFile, String useCP) {
        int size = 1 + (mode != null ? 1 : 0) + (configFile != null ? 1 : 0) + (useCP != null ? 1 : 0);
        String[] params = new String[size];
        String[] methods = new String[size];
        params[0] = mode;
        methods[0] = "setConfigMode";
        if (configFile != null) {
            params[1] = configFile;
            methods[1] = "setConfigFile";
        }
        if (useCP != null) {
            params[2] = useCP;
            methods[2] = "setUseClassPath";
        }
        params[params.length - 1] = "";
        methods[methods.length - 1] = "init";
        return TestHelper.getTestSuite(class$org$objectweb$util$monolog$TestLogger == null ? (class$org$objectweb$util$monolog$TestLogger = TestConfigurability.class$("org.objectweb.util.monolog.TestLogger")) : class$org$objectweb$util$monolog$TestLogger, methods, params, lfcn);
    }

    public void setConfigMode(String configMode) {
        this.mode = configMode;
    }

    public void setConfigFile(String configFile) {
        this.configFileName = configFile;
    }

    public void setUseClassPath(String useclasspath) {
        this.useClassPath = useclasspath;
    }

    public void init(String unused) {
        Properties prop = null;
        if (this.mode != null && !this.mode.equalsIgnoreCase("null")) {
            prop = new Properties();
            prop.put("log.config.type", this.mode);
            if (this.configFileName != null) {
                prop.put("log.config.file", this.configFileName);
            }
            if (this.useClassPath != null) {
                prop.put("log.config.file.useclasspath", this.useClassPath);
            }
            this.debug("Test the configurability with in " + this.mode + " mode" + (this.useClassPath != null ? ", use of the classpath: " + this.useClassPath : ""));
        }
        try {
            ((MonologFactory)lf).configure(prop);
        }
        catch (Exception e) {
            TestConfigurability.fail((String)("Impossible to configure in " + this.mode + " mode: " + e.getMessage()));
        }
    }

    public void testSimple() {
        this.quietRootLogger();
        TopicalLogger l = (TopicalLogger)lf.getLogger("test.configurability.simple");
        Handler hc = hf.createHandler("myhandler_configurability", "file");
        hc.setAttribute("output", "test.log");
        hc.setAttribute("pattern", "%m%n");
        hc.setAttribute("activation", lf);
        try {
            l.addHandler(hc);
        }
        catch (Exception e) {
            TestConfigurability.fail((String)e.getMessage());
        }
        l.setIntLevel(BasicLevel.DEBUG);
        String str = "configurability mode " + this.mode + " " + this.useClassPath;
        l.log(BasicLevel.DEBUG, (Object)str);
        String[] found = this.getLastLines("test.log", 1);
        TestConfigurability.assertNotNull((String)"TestHelper error", (Object)found);
        TestConfigurability.assertNotNull((String)"TestHelper error", (Object)found[0]);
        TestConfigurability.assertTrue((String)"no log in collocated Handler", (boolean)found[0].endsWith(str));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

